/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util;

import java.awt.image.BufferedImage;
import org.eweb4j.util.AbstractBufferedImageOp;

public class ContrastFilter
extends AbstractBufferedImageOp {
    private float contrast = 1.2f;
    private float brightness = 1.0f;

    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        int col;
        int tb;
        int tg;
        int tr;
        int ta;
        int width = src.getWidth();
        int height = src.getHeight();
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, null);
        }
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        src.getRGB(0, 0, width, height, inPixels, 0, width);
        int index = 0;
        int[] rgbmeans = new int[3];
        double redSum = 0.0;
        double greenSum = 0.0;
        double blueSum = 0.0;
        double total = height * width;
        int row = 0;
        while (row < height) {
            ta = 0;
            tr = 0;
            tg = 0;
            tb = 0;
            col = 0;
            while (col < width) {
                index = row * width + col;
                ta = inPixels[index] >> 24 & 0xFF;
                tr = inPixels[index] >> 16 & 0xFF;
                tg = inPixels[index] >> 8 & 0xFF;
                tb = inPixels[index] & 0xFF;
                redSum += (double)tr;
                greenSum += (double)tg;
                blueSum += (double)tb;
                ++col;
            }
            ++row;
        }
        rgbmeans[0] = (int)(redSum / total);
        rgbmeans[1] = (int)(greenSum / total);
        rgbmeans[2] = (int)(blueSum / total);
        row = 0;
        while (row < height) {
            ta = 0;
            tr = 0;
            tg = 0;
            tb = 0;
            col = 0;
            while (col < width) {
                index = row * width + col;
                ta = inPixels[index] >> 24 & 0xFF;
                tr = inPixels[index] >> 16 & 0xFF;
                tg = inPixels[index] >> 8 & 0xFF;
                tb = inPixels[index] & 0xFF;
                tr -= rgbmeans[0];
                tg -= rgbmeans[1];
                tb -= rgbmeans[2];
                tr = (int)((float)tr * this.getContrast());
                tg = (int)((float)tg * this.getContrast());
                tb = (int)((float)tb * this.getContrast());
                outPixels[index] = ta << 24 | this.clamp(tr += (int)((float)rgbmeans[0] * this.getBrightness())) << 16 | this.clamp(tg += (int)((float)rgbmeans[1] * this.getBrightness())) << 8 | this.clamp(tb += (int)((float)rgbmeans[2] * this.getBrightness()));
                ++col;
            }
            ++row;
        }
        this.setRGB(dest, 0, 0, width, height, outPixels);
        return dest;
    }

    public int clamp(int value) {
        return value > 255 ? 255 : (value < 0 ? 0 : value);
    }

    public float getContrast() {
        return this.contrast;
    }

    public void setContrast(float contrast) {
        this.contrast = contrast;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }
}

