/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonConverter {
    public static <T> String convert(T t) {
        return JsonConverter.convertFromKeyValue(null, t);
    }

    public static <T> String convert(String key, T value) {
        return JsonConverter.convert(new String[]{key}, new Object[]{value});
    }

    public static <T> String convert(String[] keys, T[] values) {
        return JsonConverter.convertWithKey(keys, values);
    }

    public static <T> String convertWithDefaultKey(T ... ts) {
        String[] keys = null;
        if (ts != null) {
            if (ts.length == 1) {
                return JsonConverter.convert(ts[0]);
            }
            keys = new String[ts.length];
            int i = 0;
            while (i < keys.length) {
                keys[i] = ts[i].getClass().getSimpleName().toLowerCase();
                ++i;
            }
        }
        return JsonConverter.convertWithKey(keys, ts);
    }

    private static <T> String convertWithKey(String[] keys, T[] ts) {
        Hashtable<String, T> map = null;
        if (keys != null && ts != null && keys.length == ts.length) {
            map = new Hashtable<String, T>();
            int i = 0;
            while (i < keys.length) {
                map.put(keys[i], ts[i]);
                ++i;
            }
        }
        return JsonConverter.convertFromMap(map);
    }

    private static String convertFromMap(Map<String, ?> map) {
        return JsonConverter.convertFromMap(null, map, false);
    }

    private static String convertFromMap(String name, Map<?, ?> map, boolean isProperty) {
        String json = null;
        if (map != null && !map.isEmpty()) {
            String format = "{%s}";
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<?, ?> entrySet : map.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((json = JsonConverter.convertFromKeyValue(String.valueOf(entrySet.getKey()), entrySet.getValue())) == null) continue;
                sb.append(json);
            }
            if (isProperty) {
                format = "\"%s\":{%s}";
                if (name == null || "".equals(name)) {
                    name = "map";
                }
                json = String.format(format, name, sb.toString());
            } else if (name != null && !"".equals(name)) {
                format = "\"%s\":{%s}";
                json = String.format(format, name, sb.toString());
            } else {
                json = String.format(format, sb.toString());
            }
        }
        return json;
    }

    private static String convertFromList(String name, List<?> list, boolean isProperty) {
        String json = null;
        if (list != null && !list.isEmpty()) {
            String format = "[%s]";
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((json = JsonConverter.convertFromKeyValue(null, list.get(i))) != null) {
                    sb.append(json);
                }
                ++i;
            }
            if (isProperty) {
                format = "\"%s\":[%s]";
                if (name == null || "".equals(name)) {
                    name = "list";
                }
                json = String.format(format, name, sb.toString());
            } else if (name != null && !"".equals(name)) {
                format = "\"%s\":[%s]";
                json = String.format(format, name, sb.toString());
            } else {
                json = String.format(format, sb.toString());
            }
        }
        return json;
    }

    private static <T> String convertFromArray(String name, T[] array, boolean isProperty) {
        String json = null;
        if (array != null && array.length > 0) {
            String format = "[%s]";
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < array.length) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((json = JsonConverter.convertFromKeyValue(null, array[i])) != null) {
                    sb.append(json);
                }
                ++i;
            }
            if (isProperty) {
                format = "\"%s\":[%s]";
                if (name == null || "".equals(name)) {
                    name = "array";
                }
                json = String.format(format, name, sb.toString());
            } else if (name != null && !"".equals(name)) {
                format = "\"%s\":[%s]";
                json = String.format(format, name, sb.toString());
            } else {
                json = String.format(format, sb.toString());
            }
        }
        return json;
    }

    private static <T> String convertFromSet(String name, Set<?> set, boolean isProperty) {
        String json = null;
        if (set != null && !set.isEmpty()) {
            String format = "[%s]";
            StringBuilder sb = new StringBuilder();
            Iterator<?> it = set.iterator();
            while (it.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((json = JsonConverter.convertFromKeyValue(null, it.next())) == null) continue;
                sb.append(json);
            }
            if (isProperty) {
                format = "\"%s\":[%s]";
                if (name == null || "".equals(name)) {
                    name = "set";
                }
                json = String.format(format, name, sb.toString());
            } else if (name != null && !"".equals(name)) {
                format = "\"%s\":[%s]";
                json = String.format(format, name, sb.toString());
            } else {
                json = String.format(format, sb.toString());
            }
        }
        return json;
    }

    private static <T> String convertFromKeyValue(String key, T value) {
        return JsonConverter.convertFromKeyValue(key, value, false);
    }

    private static <T> String convertFromKeyValue(String key, T value, boolean isProperty) {
        String json = null;
        if (value != null) {
            String format;
            Class<?> cls = value.getClass();
            String string = format = String.class.isAssignableFrom(cls) ? "\"%s\":\"%s\"" : "\"%s\":%s";
            if (String.class.isAssignableFrom(cls) || Integer.class.isAssignableFrom(cls) || Long.class.isAssignableFrom(cls) || Float.class.isAssignableFrom(cls) || Double.class.isAssignableFrom(cls) || Boolean.class.isAssignableFrom(cls) || Integer.TYPE.isAssignableFrom(cls) || Long.TYPE.isAssignableFrom(cls) || Float.TYPE.isAssignableFrom(cls) || Double.TYPE.isAssignableFrom(cls) || Boolean.TYPE.isAssignableFrom(cls)) {
                if (key == null || "".equals(key.trim())) {
                    format = String.class.isAssignableFrom(cls) ? "\"%s\"" : "%s";
                    json = String.format(format, String.valueOf(value));
                } else {
                    json = String.format(format, key, String.valueOf(value));
                }
            } else if (Object[].class.isAssignableFrom(cls)) {
                json = JsonConverter.convertFromArray(key, (Object[])value, isProperty);
            } else if (List.class.isAssignableFrom(cls)) {
                json = JsonConverter.convertFromList(key, (List)value, isProperty);
            } else if (Set.class.isAssignableFrom(cls)) {
                json = JsonConverter.convertFromSet(key, (Set)value, isProperty);
            } else if (Map.class.isAssignableFrom(cls)) {
                json = JsonConverter.convertFromMap(key, (Map)value, isProperty);
            } else {
                ReflectUtil ru = new ReflectUtil(value);
                StringBuilder sb = new StringBuilder("{");
                format = "\"%s\":%s";
                String[] stringArray = ru.getFieldsName();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    Method m = ru.getMethod("get" + CommonUtil.toUpCaseFirst(name));
                    if (m != null) {
                        try {
                            json = JsonConverter.convertFromKeyValue(name, m.invoke(value, new Object[0]), true);
                            if (json != null) {
                                if (sb.length() > 1) {
                                    sb.append(",");
                                }
                                sb.append(json);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                sb.append("}");
                if (key == null || "".equals(key)) {
                    format = "%s";
                    json = String.format(format, sb.toString());
                } else {
                    json = String.format(format, key, sb.toString());
                }
            }
        }
        return json;
    }
}

