/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.common.FelBuilder;
import com.greenpineyu.fel.compile.CompileService;
import com.greenpineyu.fel.context.ArrayCtxImpl;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.context.Var;
import com.greenpineyu.fel.function.FunMgr;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.optimizer.Optimizer;
import com.greenpineyu.fel.optimizer.VarVisitOpti;
import com.greenpineyu.fel.parser.AntlrParser;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.parser.Parser;
import com.greenpineyu.fel.security.SecurityMgr;

public class FelEngineImpl
implements FelEngine {
    private FelContext context;
    private CompileService compiler;
    private Parser parser;
    private FunMgr funMgr;
    private SecurityMgr securityMgr = FelBuilder.newSecurityMgr();

    public SecurityMgr getSecurityMgr() {
        return this.securityMgr;
    }

    public void setSecurityMgr(SecurityMgr securityMgr) {
        this.securityMgr = securityMgr;
    }

    public FelEngineImpl(FelContext context) {
        this.context = context;
        this.compiler = new CompileService();
        this.parser = new AntlrParser(this);
        this.funMgr = new FunMgr();
    }

    public FelEngineImpl() {
        this(new ArrayCtxImpl());
    }

    public FelNode parse(String exp) {
        return this.parser.parse(exp);
    }

    public Object eval(String exp) {
        return this.eval(exp, this.context);
    }

    public Object eval(String exp, Var ... vars) {
        FelNode node = this.parse(exp);
        VarVisitOpti opt = new VarVisitOpti(vars);
        node = opt.call(this.context, node);
        return node.eval(this.context);
    }

    public Object eval(String exp, FelContext ctx) {
        return this.parse(exp).eval(ctx);
    }

    public Expression compile(String exp, Var ... vars) {
        return this.compile(exp, null, new VarVisitOpti(vars));
    }

    public Expression compile(String exp, FelContext ctx, Optimizer ... opts) {
        if (ctx == null) {
            ctx = this.context;
        }
        FelNode node = this.parse(exp);
        if (opts != null) {
            Optimizer[] optimizerArray = opts;
            int n = opts.length;
            int n2 = 0;
            while (n2 < n) {
                Optimizer opt = optimizerArray[n2];
                if (opt != null) {
                    node = opt.call(ctx, node);
                }
                ++n2;
            }
        }
        return this.compiler.compile(ctx, node, exp);
    }

    public String toString() {
        return "FelEngine";
    }

    public void addFun(Function fun) {
        this.funMgr.add(fun);
    }

    public FelContext getContext() {
        return this.context;
    }

    public CompileService getCompiler() {
        return this.compiler;
    }

    public void setCompiler(CompileService compiler) {
        this.compiler = compiler;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public FunMgr getFunMgr() {
        return this.funMgr;
    }

    public void setFunMgr(FunMgr funMgr) {
        this.funMgr = funMgr;
    }

    public void setContext(FelContext context) {
        this.context = context;
    }
}

