/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.compile;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarBuffer {
    private static ThreadLocal<Stack<String>> varCodes = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> vars = new ThreadLocal();
    private static int count;
    private static ThreadLocal<String> tl;

    static {
        tl = new ThreadLocal();
    }

    private static Stack<String> getVarCodes() {
        Stack<String> stack = varCodes.get();
        if (stack == null) {
            stack = new Stack();
            varCodes.set(stack);
        }
        return stack;
    }

    private static Map<String, Object> getVars() {
        Map<String, Object> map = vars.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            vars.set(map);
        }
        return map;
    }

    public static String push(Object var) {
        return VarBuffer.push(var, var.getClass());
    }

    public static String push(Object var, Class<?> cls) {
        String varName = VarBuffer.getVarName();
        String type = cls.getName();
        String varId = UUID.randomUUID().toString();
        VarBuffer.getVars().put(varId, var);
        String code = "private static final " + type + " " + varName + " = (" + type + ")" + VarBuffer.class.getSimpleName() + ".pop(\"" + varId + "\");";
        VarBuffer.getVarCodes().push(code);
        return varName;
    }

    private static synchronized String getVarName() {
        return "attr_" + count++;
    }

    public static String pop() {
        Stack<String> stack = VarBuffer.getVarCodes();
        if (stack.empty()) {
            return null;
        }
        return stack.pop();
    }

    public static Object pop(String name) {
        return VarBuffer.getVars().remove(name);
    }

    public static void main(String[] args) {
        int i = 100;
        ExecutorService pool = Executors.newFixedThreadPool(i);
        int j = 0;
        while (j < i) {
            pool.submit(new Runnable(){

                public void run() {
                    String name = Thread.currentThread().getName();
                    System.out.println("*******************" + name + " start************************");
                    tl.set(name);
                    this.get(name);
                    System.out.println("*******************" + name + " end************************");
                }

                private void get(String name) {
                    String string = (String)tl.get();
                    System.out.println(String.valueOf(name) + ":" + (name == string));
                }
            });
            ++j;
        }
    }
}

