/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.stream.Stream;
import org.exparity.hamcrest.date.core.AnyOf;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.format.DatePartFormatter;
import org.exparity.hamcrest.date.core.format.ZonedDateTimeFormatter;
import org.exparity.hamcrest.date.core.wrapper.FieldZonedDateTimeWrapper;
import org.exparity.hamcrest.date.core.wrapper.ZonedDateTimeWrapper;
import org.hamcrest.Factory;

public abstract class ZonedDateTimeMatchers {
    public static DateMatcher<ZonedDateTime> after(ZonedDateTime date) {
        return new IsAfter<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> after(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsAfter<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, dayOfMonth, hour, minute, second, nanos, tz), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> before(ZonedDateTime date) {
        return new IsBefore<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> before(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsBefore<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, dayOfMonth, hour, minute, second, tz), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> sameDay(ZonedDateTime date) {
        return new IsSameDay<ZonedDateTime>(new ZonedDateTimeWrapper(date, (TemporalUnit)ChronoUnit.DAYS), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> isDay(int year, Month month, int dayOfMonth, ZoneId tz) {
        return new IsSameDay<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, dayOfMonth, tz), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> sameInstant(ZonedDateTime date) {
        return new IsSame<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsSame<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, dayOfMonth, hour, minute, second, nanos, tz), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> sameOrBefore(ZonedDateTime date) {
        return new IsSameOrBefore<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    @Factory
    public static DateMatcher<ZonedDateTime> sameOrBefore(int year, Month month, int day, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsSameOrBefore<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, day, hour, minute, second, nanos, tz), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> sameOrAfter(ZonedDateTime date) {
        return new IsSameOrAfter<ZonedDateTime>(new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    @Factory
    public static DateMatcher<ZonedDateTime> sameOrAfter(int year, Month month, int day, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsSameOrAfter<ZonedDateTime>(new ZonedDateTimeWrapper(year, month, day, hour, minute, second, nanos, tz), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> sameMonthOfYear(ZonedDateTime date) {
        return new IsMonth<ZonedDateTime>(new FieldZonedDateTimeWrapper(date, ChronoField.MONTH_OF_YEAR), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.MONTH_OF_YEAR));
    }

    public static DateMatcher<ZonedDateTime> sameDayOfMonth(ZonedDateTime date) {
        return new IsDayOfMonth<ZonedDateTime>(new FieldZonedDateTimeWrapper(date, ChronoField.DAY_OF_MONTH), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.DAY_OF_MONTH));
    }

    public static DateMatcher<ZonedDateTime> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<ZonedDateTime>(new FieldZonedDateTimeWrapper(dayOfMonth, ChronoField.DAY_OF_MONTH), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.DAY_OF_MONTH));
    }

    public static DateMatcher<ZonedDateTime> sameYear(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isYear(date.getYear());
    }

    public static DateMatcher<ZonedDateTime> isYear(int year) {
        return new IsYear<ZonedDateTime>(new FieldZonedDateTimeWrapper(year, ChronoField.YEAR), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.YEAR));
    }

    public static DateMatcher<ZonedDateTime> within(long period, ChronoUnit unit, ZonedDateTime date) {
        return new IsWithin<ZonedDateTime>(period, unit, new ZonedDateTimeWrapper(date), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth, int hour, int minute, int second, int nanos, ZoneId tz) {
        return new IsWithin<ZonedDateTime>(period, unit, new ZonedDateTimeWrapper(year, month, dayofMonth, hour, minute, second, nanos, tz), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> isYesterday() {
        return ZonedDateTimeMatchers.sameDay(ZonedDateTime.now().plusDays(-1L));
    }

    public static DateMatcher<ZonedDateTime> isToday() {
        return ZonedDateTimeMatchers.sameDay(ZonedDateTime.now());
    }

    public static DateMatcher<ZonedDateTime> isTomorrow() {
        return ZonedDateTimeMatchers.sameDay(ZonedDateTime.now().plusDays(1L));
    }

    public static DateMatcher<ZonedDateTime> sameDayOfWeek(ZonedDateTime date) {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.from(date));
    }

    public static DateMatcher<ZonedDateTime> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<ZonedDateTime>(new FieldZonedDateTimeWrapper(dayOfWeek.getValue(), ChronoField.DAY_OF_WEEK), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.DAY_OF_WEEK));
    }

    public static DateMatcher<ZonedDateTime> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new AnyOf<ZonedDateTime>(Stream.of(daysOfWeek).map(ZonedDateTimeMatchers::isDayOfWeek), (d, z) -> "the date is on a " + d.withZoneSameInstant((ZoneId)z).getDayOfWeek().name().toLowerCase());
    }

    public static DateMatcher<ZonedDateTime> isMonday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static DateMatcher<ZonedDateTime> isTuesday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static DateMatcher<ZonedDateTime> isWednesday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static DateMatcher<ZonedDateTime> isThursday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static DateMatcher<ZonedDateTime> isFriday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static DateMatcher<ZonedDateTime> isSaturday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static DateMatcher<ZonedDateTime> isSunday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static DateMatcher<ZonedDateTime> isWeekday() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static DateMatcher<ZonedDateTime> isWeekend() {
        return ZonedDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static DateMatcher<ZonedDateTime> isFirstDayOfMonth() {
        return new IsMinimum<ZonedDateTime>(ChronoField.DAY_OF_MONTH, (d, z) -> d.withZoneSameInstant(z).get(ChronoField.DAY_OF_MONTH), (d, z) -> ChronoField.DAY_OF_MONTH.rangeRefinedBy(d.withZoneSameInstant(z)), new DatePartFormatter(), () -> "the date is the first day of the month");
    }

    public static DateMatcher<ZonedDateTime> isMinimum(ChronoField field) {
        return new IsMinimum<ZonedDateTime>(field, (d, z) -> d.withZoneSameInstant(z).get(field), (d, z) -> field.rangeRefinedBy(d.withZoneSameInstant(z)), new DatePartFormatter());
    }

    public static DateMatcher<ZonedDateTime> isLastDayOfMonth() {
        return new IsMaximum<ZonedDateTime>(ChronoField.DAY_OF_MONTH, (d, z) -> d.withZoneSameInstant(z).get(ChronoField.DAY_OF_MONTH), (d, z) -> ChronoField.DAY_OF_MONTH.rangeRefinedBy(d.withZoneSameInstant(z)), new DatePartFormatter(), () -> "the date is the last day of the month");
    }

    public static DateMatcher<ZonedDateTime> isMaximum(ChronoField field) {
        return new IsMaximum<ZonedDateTime>(field, (d, z) -> d.withZoneSameInstant(z).get(field), (d, z) -> field.rangeRefinedBy(d.withZoneSameInstant(z)), new DatePartFormatter());
    }

    public static DateMatcher<ZonedDateTime> isMonth(Month month) {
        return new IsMonth<ZonedDateTime>(new FieldZonedDateTimeWrapper(month.getValue(), ChronoField.MONTH_OF_YEAR), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.MONTH_OF_YEAR));
    }

    public static DateMatcher<ZonedDateTime> isJanuary() {
        return ZonedDateTimeMatchers.isMonth(Month.JANUARY);
    }

    public static DateMatcher<ZonedDateTime> isFebruary() {
        return ZonedDateTimeMatchers.isMonth(Month.FEBRUARY);
    }

    public static DateMatcher<ZonedDateTime> isMarch() {
        return ZonedDateTimeMatchers.isMonth(Month.MARCH);
    }

    public static DateMatcher<ZonedDateTime> isApril() {
        return ZonedDateTimeMatchers.isMonth(Month.APRIL);
    }

    public static DateMatcher<ZonedDateTime> isMay() {
        return ZonedDateTimeMatchers.isMonth(Month.MAY);
    }

    public static DateMatcher<ZonedDateTime> isJune() {
        return ZonedDateTimeMatchers.isMonth(Month.JUNE);
    }

    public static DateMatcher<ZonedDateTime> isJuly() {
        return ZonedDateTimeMatchers.isMonth(Month.JULY);
    }

    public static DateMatcher<ZonedDateTime> isAugust() {
        return ZonedDateTimeMatchers.isMonth(Month.AUGUST);
    }

    public static DateMatcher<ZonedDateTime> isSeptember() {
        return ZonedDateTimeMatchers.isMonth(Month.SEPTEMBER);
    }

    public static DateMatcher<ZonedDateTime> isOctober() {
        return ZonedDateTimeMatchers.isMonth(Month.OCTOBER);
    }

    public static DateMatcher<ZonedDateTime> isNovember() {
        return ZonedDateTimeMatchers.isMonth(Month.NOVEMBER);
    }

    public static DateMatcher<ZonedDateTime> isDecember() {
        return ZonedDateTimeMatchers.isMonth(Month.DECEMBER);
    }

    public static DateMatcher<ZonedDateTime> isLeapYear() {
        return new IsLeapYear<ZonedDateTime>((d, z) -> d.withZoneSameInstant(z), new ZonedDateTimeFormatter());
    }

    public static DateMatcher<ZonedDateTime> isHour(int hour) {
        return new IsHour<ZonedDateTime>(new FieldZonedDateTimeWrapper(hour, ChronoField.HOUR_OF_DAY), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.HOUR_OF_DAY));
    }

    public static DateMatcher<ZonedDateTime> sameHourOfDay(ZonedDateTime date) {
        return new IsHour<ZonedDateTime>(new FieldZonedDateTimeWrapper(date, ChronoField.HOUR_OF_DAY), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.HOUR_OF_DAY));
    }

    public static DateMatcher<ZonedDateTime> isMinute(int minute) {
        return new IsMinute<ZonedDateTime>(new FieldZonedDateTimeWrapper(minute, ChronoField.MINUTE_OF_HOUR), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.MINUTE_OF_HOUR));
    }

    public static DateMatcher<ZonedDateTime> sameMinuteOfHour(ZonedDateTime date) {
        return new IsMinute<ZonedDateTime>(new FieldZonedDateTimeWrapper(date, ChronoField.MINUTE_OF_HOUR), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.MINUTE_OF_HOUR));
    }

    public static DateMatcher<ZonedDateTime> isSecond(int second) {
        return new IsSecond<ZonedDateTime>(new FieldZonedDateTimeWrapper(second, ChronoField.SECOND_OF_MINUTE), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.SECOND_OF_MINUTE));
    }

    public static DateMatcher<ZonedDateTime> sameSecondOfMinute(ZonedDateTime date) {
        return new IsSecond<ZonedDateTime>(new FieldZonedDateTimeWrapper(date, ChronoField.SECOND_OF_MINUTE), (d, z) -> ZonedDateTime.ofInstant(d.toInstant(), z).get(ChronoField.SECOND_OF_MINUTE));
    }
}

