/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.exparity.hamcrest.date.core.TemporalFormatter;
import org.exparity.hamcrest.date.core.TemporalWrapper;
import org.hamcrest.Description;

public class IsAfter<T>
extends DateMatcher<T> {
    private final TemporalWrapper<T> expected;
    private final TemporalFormatter<T> describer;

    public IsAfter(TemporalWrapper<T> expected, TemporalFormatter<T> describer) {
        this.expected = expected;
        this.describer = describer;
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        if (this.expected.isSame(actual) || this.expected.isAfter(actual)) {
            mismatchDescription.appendText("date is " + this.describer.describe(actual));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is after " + this.describer.describe(this.expected.unwrap()));
    }

    @Override
    public DateMatcher<T> atZone(ZoneId zone) {
        return new IsAfter<T>(this.expected.withZone(zone), this.describer);
    }
}

