/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import java.time.temporal.TemporalQueries;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.exparity.hamcrest.date.core.TemporalFormatter;
import org.hamcrest.Description;

public class IsLeapYear<T>
extends DateMatcher<T> {
    private final TemporalAdapter<T> adapter;
    private final TemporalFormatter<T> formatter;
    private final ZoneId zone;

    private IsLeapYear(TemporalAdapter<T> adapter, TemporalFormatter<T> formatter, ZoneId zone) {
        this.adapter = adapter;
        this.formatter = formatter;
        this.zone = zone;
    }

    public IsLeapYear(TemporalAdapter<T> adapter, TemporalFormatter<T> formatter) {
        this.adapter = adapter;
        this.formatter = formatter;
        this.zone = ZoneId.systemDefault();
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        if (!this.adapter.asTemporal(actual, this.zone).query(TemporalQueries.localDate()).isLeapYear()) {
            mismatchDesc.appendText("the date " + this.formatter.describe(actual) + " is not a leap year");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("a leap year");
    }

    @Override
    public DateMatcher<T> atZone(ZoneId zone) {
        return new IsLeapYear<T>(this.adapter, this.formatter, zone);
    }
}

