/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ValueRange;
import java.util.function.Supplier;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.exparity.hamcrest.date.core.TemporalFieldAdapter;
import org.exparity.hamcrest.date.core.TemporalFieldRangeAdapter;
import org.exparity.hamcrest.date.core.format.DatePartFormatter;
import org.hamcrest.Description;

public class IsMinimum<T>
extends DateMatcher<T> {
    private final ChronoField datePart;
    private final TemporalFieldAdapter<T> adapter;
    private final TemporalFieldRangeAdapter<T> rangeAdapter;
    private final DatePartFormatter formatter;
    private final Supplier<String> descriptionSupplier;
    private final ZoneId zone;

    private IsMinimum(ChronoField datePart, TemporalFieldAdapter<T> adapter, TemporalFieldRangeAdapter<T> rangeAdapter, DatePartFormatter formatter, Supplier<String> descriptionSupplier, ZoneId zone) {
        this.datePart = datePart;
        this.adapter = adapter;
        this.rangeAdapter = rangeAdapter;
        this.formatter = formatter;
        this.descriptionSupplier = descriptionSupplier;
        this.zone = zone;
    }

    public IsMinimum(ChronoField datePart, TemporalFieldAdapter<T> adapter, TemporalFieldRangeAdapter<T> rangeAdapter, DatePartFormatter formatter, Supplier<String> descriptionSupplier) {
        this.datePart = datePart;
        this.adapter = adapter;
        this.rangeAdapter = rangeAdapter;
        this.formatter = formatter;
        this.descriptionSupplier = descriptionSupplier;
        this.zone = ZoneId.systemDefault();
    }

    public IsMinimum(ChronoField datePart, TemporalFieldAdapter<T> adapter, TemporalFieldRangeAdapter<T> minimumAdapter, DatePartFormatter formatter) {
        this(datePart, adapter, minimumAdapter, formatter, () -> "the date is the minimum value for " + formatter.describe(datePart));
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        int actualValue = this.adapter.asTemporalField(actual, this.zone);
        ValueRange range = this.rangeAdapter.asTemporalFieldRange(actual, this.zone);
        if (range.getMinimum() != (long)actualValue) {
            mismatchDesc.appendText("date is the " + actualValue + " " + this.formatter.describe(this.datePart) + " instead of " + range.getMinimum() + " " + this.formatter.describe(this.datePart));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(this.descriptionSupplier.get());
    }

    @Override
    public DateMatcher<T> atZone(ZoneId zone) {
        return new IsMinimum<T>(this.datePart, this.adapter, this.rangeAdapter, this.formatter, this.descriptionSupplier, zone);
    }
}

