/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.function.ToIntFunction;
import org.exparity.hamcrest.date.core.TemporalFieldWrapper;

public class FieldLocalDateWrapper
implements TemporalFieldWrapper<LocalDate> {
    private final ToIntFunction<ZoneId> wrapped;
    private final ChronoField field;
    private final ZoneId zone;

    private FieldLocalDateWrapper(ToIntFunction<ZoneId> wrapped, ChronoField field, ZoneId zone) {
        this.wrapped = wrapped;
        this.field = field;
        this.zone = zone;
    }

    public FieldLocalDateWrapper(int value, ChronoField field) {
        this.wrapped = ignored -> value;
        this.field = field;
        this.zone = ZoneId.systemDefault();
    }

    public FieldLocalDateWrapper(LocalDate date, ChronoField field) {
        this.wrapped = z -> date.atStartOfDay((ZoneId)z).get(field);
        this.field = field;
        this.zone = ZoneId.systemDefault();
    }

    @Override
    public boolean isAfter(LocalDate other) {
        return this.wrapped.applyAsInt(this.zone) > other.atStartOfDay(this.zone).get(this.field);
    }

    @Override
    public boolean isBefore(LocalDate other) {
        return this.wrapped.applyAsInt(this.zone) < other.atStartOfDay(this.zone).get(this.field);
    }

    @Override
    public boolean isSame(LocalDate other) {
        return this.wrapped.applyAsInt(this.zone) == other.atStartOfDay(this.zone).get(this.field);
    }

    @Override
    public int unwrap() {
        return this.wrapped.applyAsInt(this.zone);
    }

    @Override
    public TemporalFieldWrapper<LocalDate> withZone(ZoneId zone) {
        return new FieldLocalDateWrapper(this.wrapped, this.field, zone);
    }
}

