/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.function.ToIntFunction;
import org.exparity.hamcrest.date.core.TemporalFieldWrapper;

public class FieldLocalTimeWrapper
implements TemporalFieldWrapper<LocalTime> {
    private final ToIntFunction<ZoneId> wrapped;
    private final ChronoField field;
    private final ZoneId zone;

    private FieldLocalTimeWrapper(ToIntFunction<ZoneId> wrapped, ChronoField field, ZoneId zone) {
        this.wrapped = wrapped;
        this.field = field;
        this.zone = zone;
    }

    public FieldLocalTimeWrapper(int value, ChronoField field) {
        this.wrapped = ignored -> value;
        this.field = field;
        this.zone = ZoneId.systemDefault();
    }

    public FieldLocalTimeWrapper(LocalTime date, ChronoField field) {
        this.wrapped = ignored -> date.get(field);
        this.field = field;
        this.zone = ZoneId.systemDefault();
    }

    @Override
    public boolean isAfter(LocalTime other) {
        return this.wrapped.applyAsInt(this.zone) > other.get(this.field);
    }

    @Override
    public boolean isBefore(LocalTime other) {
        return this.wrapped.applyAsInt(this.zone) < other.get(this.field);
    }

    @Override
    public boolean isSame(LocalTime other) {
        return this.wrapped.applyAsInt(this.zone) == other.get(this.field);
    }

    @Override
    public int unwrap() {
        return this.wrapped.applyAsInt(this.zone);
    }

    @Override
    public TemporalFieldWrapper<LocalTime> withZone(ZoneId zone) {
        return new FieldLocalTimeWrapper(this.wrapped, this.field, zone);
    }
}

