/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.function.ToIntFunction;
import org.exparity.hamcrest.date.core.TemporalFieldWrapper;

public class FieldZonedDateTimeWrapper
implements TemporalFieldWrapper<ZonedDateTime> {
    private final ToIntFunction<ZoneId> wrapped;
    private final ChronoField field;
    private final ZoneId zone;

    private FieldZonedDateTimeWrapper(ToIntFunction<ZoneId> wrapped, ChronoField field, ZoneId zone) {
        this.wrapped = wrapped;
        this.field = field;
        this.zone = zone;
    }

    public FieldZonedDateTimeWrapper(int value, ChronoField field) {
        this.wrapped = ignored -> value;
        this.field = field;
        this.zone = ZoneId.systemDefault();
    }

    public FieldZonedDateTimeWrapper(ZonedDateTime date, ChronoField field) {
        this.wrapped = z -> date.withZoneSameInstant((ZoneId)z).get(field);
        this.field = field;
        this.zone = ZoneId.systemDefault();
    }

    @Override
    public boolean isAfter(ZonedDateTime other) {
        return this.wrapped.applyAsInt(this.zone) > other.withZoneSameInstant(this.zone).get(this.field);
    }

    @Override
    public boolean isBefore(ZonedDateTime other) {
        return this.wrapped.applyAsInt(this.zone) < other.withZoneSameInstant(this.zone).get(this.field);
    }

    @Override
    public boolean isSame(ZonedDateTime other) {
        return this.wrapped.applyAsInt(this.zone) == other.withZoneSameInstant(this.zone).get(this.field);
    }

    @Override
    public int unwrap() {
        return this.wrapped.applyAsInt(this.zone);
    }

    @Override
    public TemporalFieldWrapper<ZonedDateTime> withZone(ZoneId zone) {
        return new FieldZonedDateTimeWrapper(this.wrapped, this.field, zone);
    }
}

