/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.function.Supplier;
import org.exparity.hamcrest.date.core.TemporalWrapper;

public class LocalDateTimeWrapper
implements TemporalWrapper<LocalDateTime> {
    private final Supplier<LocalDateTime> wrapped;
    private final ZoneId zone;
    private final TemporalUnit accuracy;

    private LocalDateTimeWrapper(Supplier<LocalDateTime> wrapped, ZoneId zone, TemporalUnit accuracy) {
        this.wrapped = wrapped;
        this.zone = zone;
        this.accuracy = accuracy;
    }

    public LocalDateTimeWrapper(Date date) {
        this(date, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public LocalDateTimeWrapper(Date date, TemporalUnit accuracy) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = () -> date.toInstant().atZone(this.zone).toLocalDateTime();
        this.accuracy = accuracy;
    }

    public LocalDateTimeWrapper(LocalDateTime date) {
        this(date, (TemporalUnit)ChronoUnit.NANOS);
    }

    public LocalDateTimeWrapper(LocalDateTime date, TemporalUnit accuracy) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = () -> date;
        this.accuracy = accuracy;
    }

    public LocalDateTimeWrapper(int year, Month month, int dayOfMonth) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = () -> LocalDate.of(year, month, dayOfMonth).atStartOfDay();
        this.accuracy = ChronoUnit.DAYS;
    }

    public LocalDateTimeWrapper(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = () -> LocalDateTime.of(year, month, dayOfMonth, hour, minute, second);
        this.accuracy = ChronoUnit.SECONDS;
    }

    public LocalDateTimeWrapper(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = () -> LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanos);
        this.accuracy = ChronoUnit.NANOS;
    }

    @Override
    public long difference(LocalDateTime other, ChronoUnit unit) {
        return Math.abs(this.wrapped.get().truncatedTo(this.accuracy).until(other, unit));
    }

    @Override
    public boolean isAfter(LocalDateTime other) {
        return this.wrapped.get().truncatedTo(this.accuracy).isAfter(other.truncatedTo(this.accuracy));
    }

    @Override
    public boolean isBefore(LocalDateTime other) {
        return this.wrapped.get().truncatedTo(this.accuracy).isBefore(other.truncatedTo(this.accuracy));
    }

    @Override
    public boolean isSame(LocalDateTime other) {
        return this.wrapped.get().truncatedTo(this.accuracy).isEqual(other.truncatedTo(this.accuracy));
    }

    @Override
    public LocalDateTime unwrap() {
        return this.wrapped.get();
    }

    public LocalDateTimeWrapper withZone(ZoneId zone) {
        return new LocalDateTimeWrapper(this.wrapped, zone, this.accuracy);
    }
}

