/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.function.Supplier;
import org.exparity.hamcrest.date.core.TemporalWrapper;

public class LocalDateWrapper
implements TemporalWrapper<LocalDate> {
    private final Supplier<LocalDate> wrapped;
    private final ZoneId zone;

    private LocalDateWrapper(Supplier<LocalDate> wrapped, ZoneId zone) {
        this.wrapped = wrapped;
        this.zone = zone;
    }

    public LocalDateWrapper(Date date) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = () -> date.toInstant().atZone(this.zone).toLocalDate();
    }

    public LocalDateWrapper(LocalDate date) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = () -> date;
    }

    @Override
    public long difference(LocalDate other, ChronoUnit unit) {
        return Math.abs(this.wrapped.get().until(other, unit));
    }

    @Override
    public boolean isAfter(LocalDate other) {
        return this.wrapped.get().isAfter(other);
    }

    @Override
    public boolean isBefore(LocalDate other) {
        return this.wrapped.get().isBefore(other);
    }

    @Override
    public boolean isSame(LocalDate other) {
        return this.wrapped.get().isEqual(other);
    }

    @Override
    public LocalDate unwrap() {
        return this.wrapped.get();
    }

    public String toString() {
        return this.wrapped.get().toString();
    }

    @Override
    public TemporalWrapper<LocalDate> withZone(ZoneId zone) {
        return new LocalDateWrapper(this.wrapped, zone);
    }
}

