/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import org.exparity.hamcrest.date.core.TemporalWrapper;

public class LocalTimeWrapper
implements TemporalWrapper<LocalTime> {
    private final LocalTime wrapped;

    public LocalTimeWrapper(LocalTime date) {
        this.wrapped = date;
    }

    public LocalTimeWrapper(int hour, int minute, int second) {
        this(LocalTime.of(hour, minute, second));
    }

    @Override
    public long difference(LocalTime other, ChronoUnit unit) {
        return Math.abs(this.wrapped.until(other, unit));
    }

    @Override
    public boolean isAfter(LocalTime other) {
        return this.wrapped.isAfter(other);
    }

    @Override
    public boolean isBefore(LocalTime other) {
        return this.wrapped.isBefore(other);
    }

    @Override
    public boolean isSame(LocalTime other) {
        return this.wrapped.equals(other);
    }

    @Override
    public LocalTime unwrap() {
        return this.wrapped;
    }

    @Override
    public TemporalWrapper<LocalTime> withZone(ZoneId zone) {
        return this;
    }
}

