/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.api.repository.AppModel;
import org.flowable.app.engine.impl.deployer.AppDeploymentManager;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class GetAppModelCmd
implements Command<AppModel> {
    protected String appDefinitionId;

    public GetAppModelCmd(String appDefinitionId) {
        this.appDefinitionId = appDefinitionId;
    }

    public AppModel execute(CommandContext commandContext) {
        if (this.appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("appDefinitionId is null");
        }
        AppDeploymentManager deploymentManager = CommandContextUtil.getAppEngineConfiguration(commandContext).getDeploymentManager();
        AppDefinition appDefinition = deploymentManager.findDeployedAppDefinitionById(this.appDefinitionId);
        if (appDefinition != null) {
            return deploymentManager.resolveAppDefinition(appDefinition).getAppModel();
        }
        return null;
    }
}

