/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntity;
import org.flowable.app.engine.impl.persistence.entity.deploy.AppDefinitionCacheEntry;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;

public class SetAppDefinitionCategoryCmd
implements Command<Void> {
    protected String appDefinitionId;
    protected String category;

    public SetAppDefinitionCategoryCmd(String appDefinitionId, String category) {
        this.appDefinitionId = appDefinitionId;
        this.category = category;
    }

    public Void execute(CommandContext commandContext) {
        if (this.appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("App definition id is null");
        }
        AppDefinitionEntity appDefinition = (AppDefinitionEntity)CommandContextUtil.getAppDefinitionEntityManager(commandContext).findById(this.appDefinitionId);
        if (appDefinition == null) {
            throw new FlowableObjectNotFoundException("No app definition found for id = '" + this.appDefinitionId + "'", AppDefinition.class);
        }
        appDefinition.setCategory(this.category);
        DeploymentCache<AppDefinitionCacheEntry> appDefinitionCache = CommandContextUtil.getAppEngineConfiguration(commandContext).getAppDefinitionCache();
        if (appDefinitionCache != null) {
            appDefinitionCache.remove(this.appDefinitionId);
        }
        return null;
    }
}

