/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.test.impl;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.flowable.app.api.repository.AppDeploymentBuilder;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.test.AppDeployment;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppTestHelper.class);
    public static final String[] APP_RESOURCE_SUFFIXES = new String[]{"app"};
    static Map<String, AppEngine> appEngines = new HashMap<String, AppEngine>();

    public static String annotationDeploymentSetUp(AppEngine appEngine, Class<?> testClass, String methodName) {
        String deploymentId = null;
        Method method = null;
        try {
            method = testClass.getMethod(methodName, null);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get method by reflection. This could happen if you are using @Parameters in combination with annotations.", (Throwable)e);
            return null;
        }
        AppDeployment deploymentAnnotation = method.getAnnotation(AppDeployment.class);
        if (deploymentAnnotation != null) {
            LOGGER.debug("annotation @AppDeployment creates deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
            String[] resources = deploymentAnnotation.resources();
            if (resources.length == 0) {
                String name = method.getName();
                String resource = AppTestHelper.getAppDefinitionResource(testClass, name);
                resources = new String[]{resource};
            }
            AppDeploymentBuilder deploymentBuilder = appEngine.getAppRepositoryService().createDeployment().name(testClass.getSimpleName() + "." + methodName);
            for (String resource : resources) {
                deploymentBuilder.addClasspathResource(resource);
            }
            if (deploymentAnnotation.tenantId() != null && deploymentAnnotation.tenantId().length() > 0) {
                deploymentBuilder.tenantId(deploymentAnnotation.tenantId());
            }
            deploymentId = deploymentBuilder.deploy().getId();
        }
        return deploymentId;
    }

    public static void annotationDeploymentTearDown(AppEngine appEngine, String deploymentId, Class<?> testClass, String methodName) {
        LOGGER.debug("annotation @AppDeployment deletes deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
        if (deploymentId != null) {
            try {
                appEngine.getAppRepositoryService().deleteDeployment(deploymentId, true);
            }
            catch (FlowableObjectNotFoundException flowableObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static AppEngine getAppEngine(String configurationResource) {
        AppEngine appEngine = appEngines.get(configurationResource);
        if (appEngine == null) {
            LOGGER.debug("==== BUILDING APP ENGINE ========================================================================");
            appEngine = AppEngineConfiguration.createAppEngineConfigurationFromResource(configurationResource).buildAppEngine();
            LOGGER.debug("==== APP ENGINE CREATED =========================================================================");
            appEngines.put(configurationResource, appEngine);
        }
        return appEngine;
    }

    public static String getAppDefinitionResource(Class<?> type, String name) {
        for (String suffix : APP_RESOURCE_SUFFIXES) {
            String resource = type.getName().replace('.', '/') + "." + name + "." + suffix;
            InputStream inputStream = ReflectUtil.getResourceAsStream((String)resource);
            if (inputStream == null) continue;
            return resource;
        }
        return type.getName().replace('.', '/') + "." + name + "." + APP_RESOURCE_SUFFIXES[0];
    }
}

