/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.converter.export.TaskExport;
import org.flowable.cmmn.model.CasePageTask;

public class CasePageTaskExport
extends AbstractPlanItemDefinitionExport<CasePageTask> {
    @Override
    public String getPlanItemDefinitionXmlElementValue(CasePageTask casePageTask) {
        return "task";
    }

    @Override
    public void writePlanItemDefinitionSpecificAttributes(CasePageTask casePageTask, XMLStreamWriter xtw) throws Exception {
        super.writePlanItemDefinitionSpecificAttributes(casePageTask, xtw);
        TaskExport.writeCommonTaskAttributes(casePageTask, xtw);
        xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "type", "casePage");
        if (StringUtils.isNotEmpty((CharSequence)casePageTask.getFormKey())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "formKey", casePageTask.getFormKey());
        }
        if (StringUtils.isNotEmpty((CharSequence)casePageTask.getLabel())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "label", casePageTask.getLabel());
        }
        if (StringUtils.isNotEmpty((CharSequence)casePageTask.getIcon())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "icon", casePageTask.getIcon());
        }
        if (StringUtils.isNotEmpty((CharSequence)casePageTask.getAssignee())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "assignee", casePageTask.getAssignee());
        }
        if (StringUtils.isNotEmpty((CharSequence)casePageTask.getOwner())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "owner", casePageTask.getOwner());
        }
        if (casePageTask.getCandidateUsers() != null && !casePageTask.getCandidateUsers().isEmpty()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "candidateUsers", CasePageTaskExport.convertListToCommaSeparatedString(casePageTask.getCandidateUsers()));
        }
        if (casePageTask.getCandidateGroups() != null && !casePageTask.getCandidateGroups().isEmpty()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "candidateGroups", CasePageTaskExport.convertListToCommaSeparatedString(casePageTask.getCandidateGroups()));
        }
    }

    @Override
    protected Class<? extends CasePageTask> getExportablePlanItemDefinitionClass() {
        return CasePageTask.class;
    }

    protected static String convertListToCommaSeparatedString(List<String> values) {
        StringBuilder valueBuilder = new StringBuilder();
        for (String value : values) {
            if (valueBuilder.length() > 0) {
                valueBuilder.append(",");
            }
            valueBuilder.append(value);
        }
        return valueBuilder.toString();
    }
}

