/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.converter.export.FieldExport;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.SendEventServiceTask;
import org.flowable.cmmn.model.Task;
import org.flowable.cmmn.model.TaskWithFieldExtensions;

public class TaskExport
extends AbstractPlanItemDefinitionExport<Task> {
    protected static <T extends TaskWithFieldExtensions> boolean writeTaskFieldExtensions(T task, boolean didWriteExtensionElement, XMLStreamWriter xtw) throws XMLStreamException {
        return FieldExport.writeFieldExtensions(task.getFieldExtensions(), didWriteExtensionElement, xtw);
    }

    protected static <T extends Task> void writeCommonTaskAttributes(T task, XMLStreamWriter xtw) throws Exception {
        SendEventServiceTask sendEventServiceTask;
        if (StringUtils.isEmpty((CharSequence)task.getBlockingExpression())) {
            if (!task.isBlocking()) {
                xtw.writeAttribute("isBlocking", "false");
            }
        } else {
            xtw.writeAttribute("isBlocking", "true");
        }
        if (StringUtils.isNotEmpty((CharSequence)task.getBlockingExpression())) {
            xtw.writeAttribute("isBlockingExpression", task.getBlockingExpression());
        }
        if (task.isAsync()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "async", String.valueOf(task.isAsync()));
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "exclusive", String.valueOf(task.isExclusive()));
        }
        if (task instanceof SendEventServiceTask && StringUtils.isNotEmpty((CharSequence)(sendEventServiceTask = (SendEventServiceTask)task).getEventType()) && sendEventServiceTask.getExtensionElements().get("eventType") == null) {
            ExtensionElement extensionElement = new ExtensionElement();
            extensionElement.setNamespace("http://flowable.org/cmmn");
            extensionElement.setNamespacePrefix("flowable");
            extensionElement.setName("eventType");
            extensionElement.setElementText(sendEventServiceTask.getEventType());
            sendEventServiceTask.addExtensionElement(extensionElement);
        }
    }

    @Override
    protected Class<Task> getExportablePlanItemDefinitionClass() {
        return Task.class;
    }

    @Override
    protected String getPlanItemDefinitionXmlElementValue(Task planItemDefinition) {
        return "task";
    }

    @Override
    protected void writePlanItemDefinitionSpecificAttributes(Task task, XMLStreamWriter xtw) throws Exception {
        super.writePlanItemDefinitionSpecificAttributes(task, xtw);
        TaskExport.writeCommonTaskAttributes(task, xtw);
    }
}

