/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.editor.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.dmn.editor.constants.DmnJsonConstants;
import org.flowable.dmn.editor.constants.DmnStencilConstants;
import org.flowable.dmn.editor.converter.DmnJsonConverterContext;
import org.flowable.dmn.editor.converter.DmnJsonConverterUtil;
import org.flowable.dmn.model.BuiltinAggregator;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DecisionTableOrientation;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnDiDiagram;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.DmnElementReference;
import org.flowable.dmn.model.DmnExtensionAttribute;
import org.flowable.dmn.model.DmnExtensionElement;
import org.flowable.dmn.model.Expression;
import org.flowable.dmn.model.GraphicInfo;
import org.flowable.dmn.model.HitPolicy;
import org.flowable.dmn.model.InformationRequirement;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.LiteralExpression;
import org.flowable.dmn.model.OutputClause;
import org.flowable.dmn.model.RuleInputClauseContainer;
import org.flowable.dmn.model.RuleOutputClauseContainer;
import org.flowable.dmn.model.UnaryTests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnJsonConverter
implements DmnJsonConstants,
DmnStencilConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DmnJsonConverter.class);
    public static final String MODEL_NAMESPACE = "http://flowable.org/dmn";
    public static final String URI_JSON = "http://www.ecma-international.org/ecma-404/";
    public static final String MODEL_VERSION = "3";
    protected ObjectMapper objectMapper = new ObjectMapper();

    public DmnDefinition convertToDmn(JsonNode modelNode) {
        return this.convertToDmn(modelNode, null, null);
    }

    public DmnDefinition convertToDmn(JsonNode modelNode, String modelId) {
        return this.convertToDmn(modelNode, modelId, null);
    }

    public DmnDefinition convertToDmn(JsonNode modelNode, String modelId, int modelVersion, Date lastUpdated) {
        return this.convertToDmn(modelNode, modelId, null);
    }

    public DmnDefinition convertToDmn(JsonNode modelNode, String modelId, DmnJsonConverterContext converterContext) {
        DmnDefinition definition = new DmnDefinition();
        if (modelId != null) {
            definition.setId("definition_" + modelId);
        }
        definition.setNamespace(MODEL_NAMESPACE);
        definition.setExporter("Flowable Open Source Modeler");
        definition.setExporterVersion(this.getClass().getPackage().getImplementationVersion());
        definition.setTypeLanguage(URI_JSON);
        if (DmnJsonConverterUtil.isDRD(modelNode)) {
            this.processDRD(modelNode, definition, converterContext);
        } else {
            this.processDecisionTableDecision(modelNode, definition);
        }
        return definition;
    }

    public ObjectNode convertToJson(DmnDefinition model) {
        if (model.getDiDiagramMap().isEmpty()) {
            return this.convertDecisionTableToJson(model);
        }
        return this.convertToDecisionServiceJson(model, null);
    }

    public ObjectNode convertToJson(DmnDefinition model, DmnJsonConverterContext converterContext) {
        if (model.getDiDiagramMap().isEmpty()) {
            return this.convertDecisionTableToJson(model);
        }
        return this.convertToDecisionServiceJson(model, converterContext);
    }

    public ObjectNode convertToDecisionServiceJson(DmnDefinition model, DmnJsonConverterContext converterContext) {
        Map<String, List<String>> sourceTargetRefMap = this.createDecisionSourceTargetRefMap(model.getDecisions());
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        Map.Entry entry = model.getDiDiagramMap().entrySet().iterator().next();
        DmnDiDiagram diDiagram = (DmnDiDiagram)entry.getValue();
        double maxX = diDiagram.getGraphicInfo().getWidth();
        double maxY = diDiagram.getGraphicInfo().getHeight();
        modelNode.set("bounds", (JsonNode)DmnJsonConverterUtil.createBoundsNode(maxX, maxY, 0.0, 0.0));
        ObjectNode stencilNode = this.objectMapper.createObjectNode();
        stencilNode.put("id", "DMNDiagram");
        modelNode.set("stencil", (JsonNode)stencilNode);
        ObjectNode stencilsetNode = this.objectMapper.createObjectNode();
        stencilsetNode.put("namespace", "http://b3mn.org/stencilset/dmn1.2#");
        stencilsetNode.put("url", "../editor/stencilsets/dmn1.1/dmn1.2.json");
        modelNode.set("stencilset", (JsonNode)stencilsetNode);
        ArrayNode shapesArrayNode = this.objectMapper.createArrayNode();
        modelNode.set("childShapes", (JsonNode)shapesArrayNode);
        if (model.getDecisionServices().isEmpty()) {
            return modelNode;
        }
        DecisionService decisionService = (DecisionService)model.getDecisionServices().get(0);
        ObjectNode expandedDecisionServiceNode = this.createExpandedDecisionServiceNode(decisionService, model);
        shapesArrayNode.add((JsonNode)expandedDecisionServiceNode);
        ArrayNode expandedDecisionServiceChildShapeNodes = this.objectMapper.createArrayNode();
        expandedDecisionServiceNode.set("childShapes", (JsonNode)expandedDecisionServiceChildShapeNodes);
        ObjectNode outputDecisionsNode = this.createOutputDecisionsNode(decisionService, model);
        expandedDecisionServiceChildShapeNodes.add((JsonNode)outputDecisionsNode);
        ArrayNode outputDecisionChildShapeNodes = this.objectMapper.createArrayNode();
        outputDecisionsNode.set("childShapes", (JsonNode)outputDecisionChildShapeNodes);
        decisionService.getOutputDecisions().forEach(decisionRef -> outputDecisionChildShapeNodes.add((JsonNode)this.createOutputDecisionNode((DmnElementReference)decisionRef, decisionService.getId(), sourceTargetRefMap, model, converterContext)));
        ObjectNode encapsulatedDecisionsNode = this.createEncapsulatedDecisionsNode(decisionService, model);
        expandedDecisionServiceChildShapeNodes.add((JsonNode)encapsulatedDecisionsNode);
        ArrayNode encapsulatedDecisionChildShapeNodes = this.objectMapper.createArrayNode();
        encapsulatedDecisionsNode.set("childShapes", (JsonNode)encapsulatedDecisionChildShapeNodes);
        decisionService.getEncapsulatedDecisions().forEach(decisionRef -> encapsulatedDecisionChildShapeNodes.add((JsonNode)this.createEncapsulatedDecisionNode((DmnElementReference)decisionRef, decisionService.getId(), sourceTargetRefMap, model, converterContext)));
        if (model.getFlowLocationMapByDiagramId(diDiagram.getId()) != null) {
            model.getFlowLocationMapByDiagramId(diDiagram.getId()).forEach((id, graphicInfoList) -> shapesArrayNode.add((JsonNode)this.createInformationRequirementNode((String)id, (List<GraphicInfo>)graphicInfoList, model)));
        }
        return modelNode;
    }

    protected Map<String, List<String>> createDecisionSourceTargetRefMap(List<Decision> decisions) {
        HashMap<String, List<String>> sourceTargetMap = new HashMap<String, List<String>>();
        for (Decision targetDecision : decisions) {
            for (InformationRequirement informationRequirement : targetDecision.getRequiredDecisions()) {
                if (informationRequirement.getRequiredDecision() == null) continue;
                String sourceDecisionId = informationRequirement.getRequiredDecision().getParsedId();
                sourceTargetMap.computeIfAbsent(sourceDecisionId, k -> new ArrayList());
                ((List)sourceTargetMap.get(sourceDecisionId)).add(informationRequirement.getId());
            }
        }
        return sourceTargetMap;
    }

    protected ObjectNode createInformationRequirementNode(String resourceId, List<GraphicInfo> graphicInfoList, DmnDefinition definition) {
        return this.createInformationRequirementNode(resourceId, graphicInfoList, null, definition);
    }

    protected ObjectNode createInformationRequirementNode(String resourceId, List<GraphicInfo> graphicInfoList, String diagramId, DmnDefinition definition) {
        GraphicInfo lowerRightGraphicInfo = graphicInfoList.get(0);
        GraphicInfo upperLeftGraphicInfo = graphicInfoList.get(1);
        ObjectNode informationRequirementNode = DmnJsonConverterUtil.createChildShape(resourceId, "InformationRequirement", lowerRightGraphicInfo.getX(), lowerRightGraphicInfo.getY(), upperLeftGraphicInfo.getX(), upperLeftGraphicInfo.getY());
        String targetDecisionId = null;
        String sourceDecisionId = null;
        block0: for (Decision decision : definition.getDecisions()) {
            for (InformationRequirement informationRequirement : decision.getRequiredDecisions()) {
                if (!informationRequirement.getId().equals(resourceId)) continue;
                sourceDecisionId = informationRequirement.getRequiredDecision().getParsedId();
                targetDecisionId = decision.getId();
                break block0;
            }
        }
        if (targetDecisionId != null && sourceDecisionId != null) {
            ArrayNode outgoingNode = this.objectMapper.createArrayNode();
            informationRequirementNode.set("outgoing", (JsonNode)outgoingNode);
            ObjectNode resourceNode = this.objectMapper.createObjectNode();
            outgoingNode.add((JsonNode)resourceNode);
            resourceNode.put("resourceId", targetDecisionId);
            ObjectNode targetNode = this.objectMapper.createObjectNode();
            informationRequirementNode.set("target", (JsonNode)targetNode);
            targetNode.put("resourceId", targetDecisionId);
            GraphicInfo sourceGraphicInfo = this.getGraphicInfo(sourceDecisionId, diagramId, definition);
            GraphicInfo targetGraphicInfo = this.getGraphicInfo(targetDecisionId, diagramId, definition);
            ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
            informationRequirementNode.set("dockers", (JsonNode)dockersArrayNode);
            ObjectNode dockNode1 = this.objectMapper.createObjectNode();
            dockNode1.put("x", sourceGraphicInfo.getWidth() / 2.0);
            dockNode1.put("y", sourceGraphicInfo.getHeight() / 2.0);
            dockersArrayNode.add((JsonNode)dockNode1);
            ObjectNode dockNode2 = this.objectMapper.createObjectNode();
            dockNode2.put("x", targetGraphicInfo.getWidth() / 2.0);
            dockNode2.put("y", targetGraphicInfo.getHeight() / 2.0);
            dockersArrayNode.add((JsonNode)dockNode2);
        }
        return informationRequirementNode;
    }

    protected ObjectNode createOutputDecisionNode(DmnElementReference decisionRef, String decisionServiceId, Map<String, List<String>> sourceTargetRefMap, DmnDefinition model, DmnJsonConverterContext converterContext) {
        return this.createOutputDecisionNode(decisionRef, decisionServiceId, null, sourceTargetRefMap, model, converterContext);
    }

    protected ObjectNode createOutputDecisionNode(DmnElementReference decisionRef, String decisionServiceId, String diagramId, Map<String, List<String>> sourceTargetRefMap, DmnDefinition model, DmnJsonConverterContext converterContext) {
        Decision decision = model.getDecisionById(decisionRef.getParsedId());
        GraphicInfo graphicInfo = this.getGraphicInfo(decision.getId(), diagramId, model);
        GraphicInfo decisionServiceGraphicInfo = this.getGraphicInfo(decisionServiceId, diagramId, model);
        ObjectNode decisionNode = DmnJsonConverterUtil.createChildShape(decision.getId(), "Decision", graphicInfo.getX() - decisionServiceGraphicInfo.getX() + graphicInfo.getWidth(), graphicInfo.getY() - decisionServiceGraphicInfo.getY() + graphicInfo.getHeight(), graphicInfo.getX() - decisionServiceGraphicInfo.getX(), graphicInfo.getY() - decisionServiceGraphicInfo.getY());
        return this.populateDecisionNode(decisionNode, decision, sourceTargetRefMap, converterContext);
    }

    protected ObjectNode createEncapsulatedDecisionNode(DmnElementReference decisionRef, String decisionServiceId, Map<String, List<String>> sourceTargetRefMap, DmnDefinition model, DmnJsonConverterContext converterContext) {
        return this.createEncapsulatedDecisionNode(decisionRef, decisionServiceId, null, sourceTargetRefMap, model, converterContext);
    }

    protected ObjectNode createEncapsulatedDecisionNode(DmnElementReference decisionRef, String decisionServiceId, String diagramId, Map<String, List<String>> sourceTargetRefMap, DmnDefinition model, DmnJsonConverterContext converterContext) {
        Decision decision = model.getDecisionById(decisionRef.getParsedId());
        GraphicInfo graphicInfo = this.getGraphicInfo(decision.getId(), diagramId, model);
        List<GraphicInfo> decisionServiceDividerGraphicInfoList = this.getDecisionServiceDividerGraphicInfos(decisionServiceId, diagramId, model);
        GraphicInfo encapsulatedDecisionsGraphicInfo = decisionServiceDividerGraphicInfoList.get(0);
        ObjectNode decisionNode = DmnJsonConverterUtil.createChildShape(decision.getId(), "Decision", graphicInfo.getX() - encapsulatedDecisionsGraphicInfo.getX() + graphicInfo.getWidth(), graphicInfo.getY() - encapsulatedDecisionsGraphicInfo.getY() + graphicInfo.getHeight(), graphicInfo.getX() - encapsulatedDecisionsGraphicInfo.getX(), graphicInfo.getY() - encapsulatedDecisionsGraphicInfo.getY());
        return this.populateDecisionNode(decisionNode, decision, sourceTargetRefMap, converterContext);
    }

    protected ObjectNode populateDecisionNode(ObjectNode decisionNode, Decision decision, Map<String, List<String>> sourceTargetRefMap, DmnJsonConverterContext converterContext) {
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        decisionNode.set("properties", (JsonNode)propertiesNode);
        propertiesNode.put("name", decision.getName());
        if (converterContext != null && converterContext.getDecisionTableModelInfoForDecisionTableModelKey(decision.getId()) != null) {
            Map<String, String> modelInfo = converterContext.getDecisionTableModelInfoForDecisionTableModelKey(decision.getId());
            ObjectNode modelRefNode = propertiesNode.putObject("decisiondecisiontablereference");
            modelRefNode.put("id", modelInfo.get("id"));
            modelRefNode.put("name", modelInfo.get("name"));
            modelRefNode.put("key", decision.getId());
        } else {
            ObjectNode modelRefNode = propertiesNode.putObject("decisiondecisiontablereference");
            modelRefNode.put("key", decision.getId());
        }
        ArrayNode outgoingNodeArray = this.objectMapper.createArrayNode();
        decisionNode.set("outgoing", (JsonNode)outgoingNodeArray);
        if (sourceTargetRefMap.containsKey(decision.getId())) {
            sourceTargetRefMap.get(decision.getId()).forEach(targetDecisionId -> {
                ObjectNode outgoingNode = this.objectMapper.createObjectNode();
                outgoingNodeArray.add((JsonNode)outgoingNode);
                outgoingNode.put("resourceId", targetDecisionId);
            });
        }
        return decisionNode;
    }

    protected ObjectNode createOutputDecisionsNode(DecisionService decisionService, DmnDefinition model) {
        return this.createOutputDecisionsNode(decisionService, null, model);
    }

    protected ObjectNode createOutputDecisionsNode(DecisionService decisionService, String diDiagramId, DmnDefinition model) {
        List<GraphicInfo> decisionServiceDividerGraphicInfoList = this.getDecisionServiceDividerGraphicInfos(decisionService.getId(), diDiagramId, model);
        GraphicInfo outputDecisionsGraphicInfo = decisionServiceDividerGraphicInfoList.get(0);
        String resourceId = decisionService.getId() + "_outputDecisions";
        ObjectNode outputDecisionsNode = DmnJsonConverterUtil.createChildShape(resourceId, "OutputDecisionsDecisionServiceSection", outputDecisionsGraphicInfo.getWidth(), outputDecisionsGraphicInfo.getHeight(), 0.0, 0.0);
        return outputDecisionsNode;
    }

    protected ObjectNode createEncapsulatedDecisionsNode(DecisionService decisionService, DmnDefinition model) {
        return this.createEncapsulatedDecisionsNode(decisionService, null, model);
    }

    protected ObjectNode createEncapsulatedDecisionsNode(DecisionService decisionService, String diDiagramId, DmnDefinition model) {
        List<GraphicInfo> decisionServiceDividerGraphicInfoList = this.getDecisionServiceDividerGraphicInfos(decisionService.getId(), diDiagramId, model);
        GraphicInfo outputDecisionsGraphicInfo = decisionServiceDividerGraphicInfoList.get(0);
        GraphicInfo encapsulatedDecisionsGraphicInfo = decisionServiceDividerGraphicInfoList.get(1);
        String resourceId = decisionService.getId() + "_encapsulatedDecisions";
        ObjectNode encapsulatedDecisionsNode = DmnJsonConverterUtil.createChildShape(resourceId, "EncapsulatedDecisionsDecisionServiceSection", encapsulatedDecisionsGraphicInfo.getWidth(), encapsulatedDecisionsGraphicInfo.getHeight() + outputDecisionsGraphicInfo.getHeight(), 0.0, outputDecisionsGraphicInfo.getHeight());
        return encapsulatedDecisionsNode;
    }

    protected ObjectNode createExpandedDecisionServiceNode(DecisionService decisionService, DmnDefinition model) {
        return this.createExpandedDecisionServiceNode(decisionService, null, model);
    }

    protected ObjectNode createExpandedDecisionServiceNode(DecisionService decisionService, String diDiagramId, DmnDefinition model) {
        GraphicInfo decisionServiceGraphicInfo = this.getGraphicInfo(decisionService.getId(), diDiagramId, model);
        ObjectNode decisionServiceNode = DmnJsonConverterUtil.createChildShape(decisionService.getId(), "ExpandedDecisionService", decisionServiceGraphicInfo.getX() + decisionServiceGraphicInfo.getWidth(), decisionServiceGraphicInfo.getY() + decisionServiceGraphicInfo.getHeight(), decisionServiceGraphicInfo.getX(), decisionServiceGraphicInfo.getY());
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        if (StringUtils.isNotEmpty((CharSequence)decisionService.getId())) {
            propertiesNode.put("overrideid", decisionService.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)decisionService.getName())) {
            propertiesNode.put("name", decisionService.getName());
        }
        decisionServiceNode.set("properties", (JsonNode)propertiesNode);
        return decisionServiceNode;
    }

    protected GraphicInfo getGraphicInfo(String dmnElementId, String diDiagramId, DmnDefinition model) {
        GraphicInfo graphicInfo = null;
        graphicInfo = StringUtils.isNotEmpty((CharSequence)diDiagramId) ? (GraphicInfo)model.getLocationMapByDiagramId(diDiagramId).get(dmnElementId) : model.getGraphicInfo(dmnElementId);
        if (graphicInfo == null) {
            throw new FlowableException("Could not find graphic info for element with id: " + dmnElementId);
        }
        return graphicInfo;
    }

    protected List<GraphicInfo> getDecisionServiceDividerGraphicInfos(String decisionServiceId, String diDiagramId, DmnDefinition model) {
        List graphicInfos = StringUtils.isNotEmpty((CharSequence)diDiagramId) ? (List)model.getDecisionServiceDividerLocationMapByDiagramId(diDiagramId).get(decisionServiceId) : model.getDecisionServiceDividerGraphicInfo(decisionServiceId);
        if (graphicInfos == null) {
            throw new FlowableException("Could not find decision service divider graphic info for decision service with id: " + decisionServiceId);
        }
        return graphicInfos;
    }

    public ObjectNode convertDecisionTableToJson(DmnDefinition definition) {
        Decision firstDecision = (Decision)definition.getDecisions().get(0);
        return this.convertDecisionDecisionTableToJson(firstDecision, definition.getId(), definition.getName(), definition.getDescription());
    }

    public ObjectNode convertDecisionDecisionTableToJson(Decision decision, String id, String name, String description) {
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        DecisionTable decisionTable = (DecisionTable)decision.getExpression();
        modelNode.put("id", id);
        modelNode.put("key", decision.getId());
        modelNode.put("name", name);
        modelNode.put("version", MODEL_VERSION);
        modelNode.put("description", description);
        if (decisionTable == null) {
            return modelNode;
        }
        modelNode.put("hitIndicator", decisionTable.getHitPolicy().name());
        if (decisionTable.getAggregation() != null) {
            modelNode.put("collectOperator", decisionTable.getAggregation().name());
        }
        if (decision.isForceDMN11()) {
            modelNode.put("forceDMN11", true);
        }
        ArrayNode inputExpressionsNode = this.objectMapper.createArrayNode();
        for (Object clause : decisionTable.getInputs()) {
            LiteralExpression inputExpression = clause.getInputExpression();
            ObjectNode inputExpressionNode = this.objectMapper.createObjectNode();
            inputExpressionNode.put("id", inputExpression.getId());
            inputExpressionNode.put("type", inputExpression.getTypeRef());
            inputExpressionNode.put("label", clause.getLabel());
            inputExpressionNode.put("variableId", inputExpression.getText());
            inputExpressionsNode.add((JsonNode)inputExpressionNode);
        }
        modelNode.set("inputExpressions", (JsonNode)inputExpressionsNode);
        ArrayNode outputExpressionsNode = this.objectMapper.createArrayNode();
        for (OutputClause clause : decisionTable.getOutputs()) {
            ObjectNode outputExpressionNode = this.objectMapper.createObjectNode();
            outputExpressionNode.put("id", clause.getId());
            outputExpressionNode.put("type", clause.getTypeRef());
            outputExpressionNode.put("label", clause.getLabel());
            outputExpressionNode.put("variableId", clause.getName());
            outputExpressionsNode.add((JsonNode)outputExpressionNode);
        }
        modelNode.set("outputExpressions", (JsonNode)outputExpressionsNode);
        ArrayNode rulesNode = this.objectMapper.createArrayNode();
        for (DecisionRule rule : decisionTable.getRules()) {
            ObjectNode ruleNode = this.objectMapper.createObjectNode();
            for (RuleInputClauseContainer ruleClauseContainer : rule.getInputEntries()) {
                InputClause inputClause = ruleClauseContainer.getInputClause();
                UnaryTests inputEntry = ruleClauseContainer.getInputEntry();
                String inputExpressionId = inputClause.getInputExpression().getId();
                String operatorId = inputExpressionId + "_operator";
                String expressionId = inputExpressionId + "_expression";
                String expressionText = inputEntry.getText();
                String operatorValue = null;
                String expressionValue = null;
                if (inputEntry.getExtensionElements() != null && !inputEntry.getExtensionElements().isEmpty()) {
                    if (inputEntry.getExtensionElements().containsKey("operator")) {
                        operatorValue = ((DmnExtensionElement)((List)inputEntry.getExtensionElements().get("operator")).get(0)).getElementText();
                    }
                    if (inputEntry.getExtensionElements().containsKey("expression")) {
                        expressionValue = ((DmnExtensionElement)((List)inputEntry.getExtensionElements().get("expression")).get(0)).getElementText();
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)expressionText)) {
                    if (expressionText.startsWith("${") || expressionText.startsWith("#{")) {
                        expressionValue = expressionText;
                    } else {
                        if (expressionText.indexOf(32) != -1) {
                            operatorValue = expressionText.substring(0, expressionText.indexOf(32));
                            expressionValue = expressionText.substring(expressionText.indexOf(32) + 1);
                        } else {
                            expressionValue = expressionText;
                        }
                        if (expressionValue.startsWith("\"") && expressionValue.endsWith("\"")) {
                            expressionValue = expressionValue.substring(1, expressionValue.length() - 1);
                        }
                        if (expressionValue.startsWith("fn_date(")) {
                            expressionValue = expressionValue.substring(9, expressionValue.lastIndexOf(39));
                        } else if (expressionValue.startsWith("date:toDate(")) {
                            expressionValue = expressionValue.substring(13, expressionValue.lastIndexOf(39));
                        }
                    }
                }
                ruleNode.put(operatorId, operatorValue);
                ruleNode.put(expressionId, expressionValue);
            }
            for (RuleInputClauseContainer ruleClauseContainer : rule.getOutputEntries()) {
                OutputClause outputClause = ruleClauseContainer.getOutputClause();
                LiteralExpression outputEntry = ruleClauseContainer.getOutputEntry();
                ruleNode.put(outputClause.getId(), outputEntry.getText());
            }
            rulesNode.add((JsonNode)ruleNode);
        }
        modelNode.set("rules", (JsonNode)rulesNode);
        return modelNode;
    }

    protected void processDRD(JsonNode modelNode, DmnDefinition definition, DmnJsonConverterContext converterContext) {
        HashMap<String, JsonNode> shapeMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> sourceRefMap = new HashMap<String, JsonNode>();
        HashMap<String, List<JsonNode>> targetRefMap = new HashMap<String, List<JsonNode>>();
        HashMap<String, JsonNode> edgeMap = new HashMap<String, JsonNode>();
        HashMap<String, List<JsonNode>> sourceAndTargetMap = new HashMap<String, List<JsonNode>>();
        this.preProcessShapes(modelNode, shapeMap, sourceRefMap);
        this.preProcessFlows(modelNode, edgeMap, shapeMap, sourceRefMap, sourceAndTargetMap, targetRefMap);
        ArrayNode shapesArrayNode = (ArrayNode)modelNode.get("childShapes");
        if (shapesArrayNode == null || shapesArrayNode.size() == 0) {
            return;
        }
        String decisionServiceId = DmnJsonConverterUtil.getPropertyValueAsString("drd_id", modelNode);
        String decisionServiceName = DmnJsonConverterUtil.getPropertyValueAsString("name", modelNode);
        definition.setName(decisionServiceName);
        shapesArrayNode.forEach(shapeNode -> {
            String stencilId = DmnJsonConverterUtil.getStencilId(shapeNode);
            if ("ExpandedDecisionService".equals(stencilId)) {
                DecisionService decisionService = new DecisionService();
                definition.addDecisionService(decisionService);
                decisionService.setId(decisionServiceId);
                if (StringUtils.isNotEmpty((CharSequence)decisionServiceName)) {
                    decisionService.setName(decisionServiceName);
                } else {
                    decisionService.setName(decisionServiceId);
                }
                ArrayNode decisionServiceShapesArrayNode = (ArrayNode)shapeNode.get("childShapes");
                if (decisionServiceShapesArrayNode == null || decisionServiceShapesArrayNode.size() == 0) {
                    return;
                }
                decisionServiceShapesArrayNode.forEach(decisionServiceChildNode -> {
                    String decisionServiceChildNodeStencilId = DmnJsonConverterUtil.getStencilId(decisionServiceChildNode);
                    if ("OutputDecisionsDecisionServiceSection".equals(decisionServiceChildNodeStencilId)) {
                        this.processDRDDecision(definition, (JsonNode)decisionServiceChildNode, converterContext, sourceRefMap, targetRefMap, decisionService.getOutputDecisions());
                    } else if ("EncapsulatedDecisionsDecisionServiceSection".equals(decisionServiceChildNodeStencilId)) {
                        this.processDRDDecision(definition, (JsonNode)decisionServiceChildNode, converterContext, sourceRefMap, targetRefMap, decisionService.getEncapsulatedDecisions());
                    }
                });
            }
        });
        this.readShapeDI(modelNode, 0.0, 0.0, definition);
        this.readEdgeDI(edgeMap, sourceAndTargetMap, definition);
    }

    protected void readShapeDI(JsonNode objectNode, double parentX, double parentY, DmnDefinition definition) {
        JsonNode boundsNode = objectNode.get("bounds");
        ObjectNode upperLeftNode = (ObjectNode)boundsNode.get("upperLeft");
        ObjectNode lowerRightNode = (ObjectNode)boundsNode.get("lowerRight");
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(upperLeftNode.get("x").asDouble() + parentX);
        graphicInfo.setY(upperLeftNode.get("y").asDouble() + parentY);
        graphicInfo.setWidth(lowerRightNode.get("x").asDouble() - graphicInfo.getX() + parentX);
        graphicInfo.setHeight(lowerRightNode.get("y").asDouble() - graphicInfo.getY() + parentY);
        DmnDiDiagram diagram = new DmnDiDiagram();
        diagram.setName(DmnJsonConverterUtil.getValueAsString("name", objectNode));
        diagram.setId("DMNDiagram_" + DmnJsonConverterUtil.getPropertyValueAsString("drd_id", objectNode));
        diagram.setGraphicInfo(graphicInfo);
        definition.addDiDiagram(diagram);
        this.readShapeDI(objectNode, parentX, parentY, definition, diagram.getId(), null);
    }

    protected void readShapeDI(JsonNode objectNode, double parentX, double parentY, DmnDefinition definition, String currentDiagramId, String parentElementId) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                String stencilId = DmnJsonConverterUtil.getStencilId(jsonChildNode);
                if ("InformationRequirement".equals(stencilId)) continue;
                String currentElementId = DmnJsonConverterUtil.getElementId(jsonChildNode);
                JsonNode boundsNode = jsonChildNode.get("bounds");
                ObjectNode upperLeftNode = (ObjectNode)boundsNode.get("upperLeft");
                ObjectNode lowerRightNode = (ObjectNode)boundsNode.get("lowerRight");
                if ("OutputDecisionsDecisionServiceSection".equals(stencilId)) {
                    GraphicInfo graphicInfoLeft = new GraphicInfo();
                    graphicInfoLeft.setX(upperLeftNode.get("x").asDouble() + parentX);
                    graphicInfoLeft.setY(upperLeftNode.get("y").asDouble() + lowerRightNode.get("y").asDouble() + parentY);
                    graphicInfoLeft.setWidth(lowerRightNode.get("x").asDouble());
                    graphicInfoLeft.setHeight(lowerRightNode.get("y").asDouble());
                    LinkedList<GraphicInfo> graphicInfoList = new LinkedList<GraphicInfo>(Arrays.asList(graphicInfoLeft));
                    definition.addDecisionServiceDividerGraphicInfoListByDiagramId(currentDiagramId, parentElementId, graphicInfoList);
                    this.readShapeDI(jsonChildNode, upperLeftNode.get("x").asDouble() + parentX, upperLeftNode.get("y").asDouble() + parentY, definition, currentDiagramId, currentElementId);
                    continue;
                }
                if ("EncapsulatedDecisionsDecisionServiceSection".equals(stencilId)) {
                    GraphicInfo graphicInfoRight = new GraphicInfo();
                    graphicInfoRight.setX(lowerRightNode.get("x").asDouble() + parentX);
                    graphicInfoRight.setY(upperLeftNode.get("y").asDouble() + parentY);
                    graphicInfoRight.setWidth(lowerRightNode.get("x").asDouble());
                    graphicInfoRight.setHeight(lowerRightNode.get("y").asDouble() - upperLeftNode.get("y").asDouble());
                    ((List)definition.getDecisionServiceDividerLocationMapByDiagramId(currentDiagramId).get(parentElementId)).add(graphicInfoRight);
                    this.readShapeDI(jsonChildNode, upperLeftNode.get("x").asDouble() + parentX, upperLeftNode.get("y").asDouble() + parentY, definition, currentDiagramId, currentElementId);
                    continue;
                }
                GraphicInfo graphicInfo = new GraphicInfo();
                graphicInfo.setX(upperLeftNode.get("x").asDouble() + parentX);
                graphicInfo.setY(upperLeftNode.get("y").asDouble() + parentY);
                graphicInfo.setWidth(lowerRightNode.get("x").asDouble() - upperLeftNode.get("x").asDouble());
                graphicInfo.setHeight(lowerRightNode.get("y").asDouble() - upperLeftNode.get("y").asDouble());
                if ("ExpandedDecisionService".equals(stencilId) && !definition.getDecisionServices().isEmpty()) {
                    currentElementId = ((DecisionService)definition.getDecisionServices().get(0)).getId();
                }
                definition.addGraphicInfoByDiagramId(currentDiagramId, currentElementId, graphicInfo);
                this.readShapeDI(jsonChildNode, graphicInfo.getX(), graphicInfo.getY(), definition, currentDiagramId, currentElementId);
            }
        }
    }

    protected void readEdgeDI(Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, DmnDefinition definition) {
        Map.Entry diagramEntry = definition.getDiDiagramMap().entrySet().iterator().next();
        DmnDiDiagram diDiagram = (DmnDiDiagram)diagramEntry.getValue();
        for (Map.Entry<String, JsonNode> entry : edgeMap.entrySet()) {
            Line2D.Double lastLine;
            String edgeId = entry.getKey();
            JsonNode edgeNode = entry.getValue();
            List<JsonNode> sourceAndTargetList = sourceAndTargetMap.get(edgeId);
            JsonNode sourceRefNode = null;
            JsonNode targetRefNode = null;
            if (sourceAndTargetList != null && sourceAndTargetList.size() > 1) {
                sourceRefNode = sourceAndTargetList.get(0);
                targetRefNode = sourceAndTargetList.get(1);
            }
            if (sourceRefNode == null) {
                LOGGER.info("Skipping edge {} because source ref is null", (Object)edgeId);
                continue;
            }
            if (targetRefNode == null) {
                LOGGER.info("Skipping edge {} because target ref is null", (Object)edgeId);
                continue;
            }
            JsonNode dockersNode = edgeNode.get("dockers");
            double sourceDockersX = dockersNode.get(0).get("x").asDouble();
            double sourceDockersY = dockersNode.get(0).get("y").asDouble();
            GraphicInfo sourceInfo = definition.getGraphicInfoByDiagramId(diDiagram.getId(), DmnJsonConverterUtil.getElementId(sourceRefNode));
            GraphicInfo targetInfo = definition.getGraphicInfoByDiagramId(diDiagram.getId(), DmnJsonConverterUtil.getElementId(targetRefNode));
            double sourceRefLineX = sourceInfo.getX() + sourceDockersX;
            double sourceRefLineY = sourceInfo.getY() + sourceDockersY;
            double nextPointInLineX = dockersNode.get(1).get("x").asDouble();
            double nextPointInLineY = dockersNode.get(1).get("y").asDouble();
            if (dockersNode.size() == 2) {
                nextPointInLineX += targetInfo.getX();
                nextPointInLineY += targetInfo.getY();
            }
            Line2D.Double firstLine = new Line2D.Double(sourceRefLineX, sourceRefLineY, nextPointInLineX, nextPointInLineY);
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            Area source2D = DmnJsonConverterUtil.createRectangle(sourceInfo);
            if (source2D != null) {
                Collection<Point2D> intersections = DmnJsonConverterUtil.getIntersections(firstLine, source2D);
                if (intersections != null && intersections.size() > 0) {
                    Point2D intersection = intersections.iterator().next();
                    graphicInfoList.add(DmnJsonConverterUtil.createGraphicInfo(intersection.getX(), intersection.getY()));
                } else {
                    graphicInfoList.add(DmnJsonConverterUtil.createGraphicInfo(sourceRefLineX, sourceRefLineY));
                }
            }
            if (dockersNode.size() > 2) {
                for (int i = 1; i < dockersNode.size() - 1; ++i) {
                    double x = dockersNode.get(i).get("x").asDouble();
                    double y = dockersNode.get(i).get("y").asDouble();
                    graphicInfoList.add(DmnJsonConverterUtil.createGraphicInfo(x, y));
                }
                double startLastLineX = dockersNode.get(dockersNode.size() - 2).get("x").asDouble();
                double startLastLineY = dockersNode.get(dockersNode.size() - 2).get("y").asDouble();
                double endLastLineX = dockersNode.get(dockersNode.size() - 1).get("x").asDouble();
                double endLastLineY = dockersNode.get(dockersNode.size() - 1).get("y").asDouble();
                lastLine = new Line2D.Double(startLastLineX, startLastLineY, endLastLineX += targetInfo.getX(), endLastLineY += targetInfo.getY());
            } else {
                lastLine = firstLine;
            }
            Area target2D = DmnJsonConverterUtil.createRectangle(targetInfo);
            if (target2D != null) {
                Collection<Point2D> intersections = DmnJsonConverterUtil.getIntersections(lastLine, target2D);
                if (intersections != null && intersections.size() > 0) {
                    Point2D intersection = intersections.iterator().next();
                    graphicInfoList.add(DmnJsonConverterUtil.createGraphicInfo(intersection.getX(), intersection.getY()));
                } else {
                    graphicInfoList.add(DmnJsonConverterUtil.createGraphicInfo(((Line2D)lastLine).getX2(), ((Line2D)lastLine).getY2()));
                }
            }
            definition.addFlowGraphicInfoListByDiagramId(diDiagram.getId(), edgeId, graphicInfoList);
        }
    }

    protected void processDRDDecision(DmnDefinition definition, JsonNode decisionServiceChildNode, DmnJsonConverterContext converterContext, Map<String, JsonNode> sourceRefMap, Map<String, List<JsonNode>> targetRefMap, List<DmnElementReference> decisionServiceDecisions) {
        ArrayNode decisionsArrayNode = (ArrayNode)decisionServiceChildNode.get("childShapes");
        if (decisionsArrayNode == null || decisionsArrayNode.size() == 0) {
            return;
        }
        decisionsArrayNode.forEach(decisionChildNode -> {
            Decision decision = new Decision();
            decision.setDmnDefinition(definition);
            decision.setId(DmnJsonConverterUtil.getElementId(decisionChildNode));
            decision.setName(DmnJsonConverterUtil.getPropertyValueAsString("name", decisionChildNode));
            JsonNode decisionTableReferenceNode = DmnJsonConverterUtil.getProperty("decisiondecisiontablereference", decisionChildNode);
            if (decisionTableReferenceNode != null && decisionTableReferenceNode.has("key") && !decisionTableReferenceNode.get("key").isNull()) {
                String decisionTableKey = decisionTableReferenceNode.get("key").asText();
                if (converterContext != null && converterContext.getDecisionTableKeyToJsonStringMap() != null) {
                    String decisionTableEditorJson = converterContext.getDecisionTableKeyToJsonStringMap().get(decisionTableKey);
                    if (StringUtils.isNotEmpty((CharSequence)decisionTableEditorJson)) {
                        try {
                            JsonNode decisionTableNode = this.objectMapper.readTree(decisionTableEditorJson);
                            DecisionTable decisionTable = new DecisionTable();
                            decision.setExpression((Expression)decisionTable);
                            this.processDecisionTable(decisionTableNode, decisionTable);
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error while parsing decision table editor JSON: {}", (Object)decisionTableEditorJson);
                        }
                    } else {
                        LOGGER.warn("Could not find decision table for key: {}", (Object)decisionTableKey);
                    }
                }
            }
            if (targetRefMap.containsKey(decisionChildNode.get("resourceId").asText())) {
                List informationRequirementNodes = (List)targetRefMap.get(decisionChildNode.get("resourceId").asText());
                informationRequirementNodes.forEach(informationRequirementNode -> {
                    InformationRequirement informationRequirement = new InformationRequirement();
                    informationRequirement.setId(DmnJsonConverterUtil.getElementId(informationRequirementNode));
                    informationRequirement.setName(DmnJsonConverterUtil.getPropertyValueAsString("name", informationRequirementNode));
                    JsonNode requiredDecisionNode = (JsonNode)sourceRefMap.get(DmnJsonConverterUtil.getElementId(informationRequirementNode));
                    DmnElementReference requiredDecisionReference = this.createDmnElementReference(requiredDecisionNode);
                    informationRequirement.setRequiredDecision(requiredDecisionReference);
                    decision.addRequiredDecision(informationRequirement);
                });
            }
            decisionServiceDecisions.add(this.createDmnElementReference((JsonNode)decisionChildNode));
            definition.addDecision(decision);
        });
    }

    protected DmnElementReference createDmnElementReference(JsonNode node) {
        DmnElementReference dmnElementReference = new DmnElementReference();
        String decisionHref = "#" + DmnJsonConverterUtil.getElementId(node);
        dmnElementReference.setHref(decisionHref);
        return dmnElementReference;
    }

    protected DmnElementReference createDmnElementReference(DmnElement element) {
        DmnElementReference dmnElementReference = new DmnElementReference();
        String decisionHref = "#" + element.getId();
        dmnElementReference.setHref(decisionHref);
        return dmnElementReference;
    }

    protected void preProcessShapes(JsonNode objectNode, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                String stencilId = DmnJsonConverterUtil.getStencilId(jsonChildNode);
                if ("InformationRequirement".equals(stencilId)) continue;
                String childShapeId = jsonChildNode.get("resourceId").asText();
                shapeMap.put(childShapeId, jsonChildNode);
                ArrayNode outgoingNode = (ArrayNode)jsonChildNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null) continue;
                        sourceRefMap.put(resourceNode.asText(), jsonChildNode);
                    }
                }
                this.preProcessShapes(jsonChildNode, shapeMap, sourceRefMap);
            }
        }
    }

    protected void preProcessFlows(JsonNode objectNode, Map<String, JsonNode> edgeMap, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap, Map<String, List<JsonNode>> sourceAndTargetMap, Map<String, List<JsonNode>> targetRefMap) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                String stencilId = DmnJsonConverterUtil.getStencilId(jsonChildNode);
                if (!"InformationRequirement".equals(stencilId)) {
                    this.preProcessFlows(jsonChildNode, edgeMap, shapeMap, sourceRefMap, sourceAndTargetMap, targetRefMap);
                    continue;
                }
                String childEdgeId = DmnJsonConverterUtil.getElementId(jsonChildNode);
                JsonNode targetNode = jsonChildNode.get("target");
                if (targetNode != null && !targetNode.isNull()) {
                    String targetRefId = targetNode.get("resourceId").asText();
                    ArrayList<JsonNode> sourceAndTargetList = new ArrayList<JsonNode>();
                    sourceAndTargetList.add(sourceRefMap.get(jsonChildNode.get("resourceId").asText()));
                    sourceAndTargetList.add(shapeMap.get(targetRefId));
                    sourceAndTargetMap.put(childEdgeId, sourceAndTargetList);
                    if (targetRefMap.containsKey(targetRefId)) {
                        LOGGER.debug("ALREADY CONTAINS");
                    }
                    targetRefMap.computeIfAbsent(targetRefId, k -> new ArrayList());
                    targetRefMap.get(targetRefId).add(jsonChildNode);
                }
                edgeMap.put(childEdgeId, jsonChildNode);
            }
        }
    }

    protected void processDecisionTableDecision(JsonNode modelNode, DmnDefinition definition) {
        DmnJsonConverterUtil.migrateModel(modelNode, this.objectMapper);
        definition.setName(DmnJsonConverterUtil.getValueAsString("name", modelNode));
        Decision decision = new Decision();
        decision.setId(DmnJsonConverterUtil.getValueAsString("key", modelNode));
        decision.setName(DmnJsonConverterUtil.getValueAsString("name", modelNode));
        decision.setDescription(DmnJsonConverterUtil.getValueAsString("description", modelNode));
        if (modelNode.has("forceDMN11") && "true".equals(DmnJsonConverterUtil.getValueAsString("forceDMN11", modelNode))) {
            decision.setForceDMN11(true);
        }
        definition.addDecision(decision);
        DecisionTable decisionTable = new DecisionTable();
        decision.setExpression((Expression)decisionTable);
        this.processDecisionTable(modelNode, decisionTable);
    }

    protected void processDecisionTable(JsonNode modelNode, DecisionTable decisionTable) {
        if (decisionTable == null) {
            return;
        }
        decisionTable.setId(DmnJsonConverterUtil.getUniqueElementId("decisionTable"));
        if (modelNode.has("hitIndicator")) {
            decisionTable.setHitPolicy(HitPolicy.get((String)DmnJsonConverterUtil.getValueAsString("hitIndicator", modelNode)));
        } else {
            decisionTable.setHitPolicy(HitPolicy.FIRST);
        }
        if (modelNode.has("collectOperator")) {
            decisionTable.setAggregation(BuiltinAggregator.get((String)DmnJsonConverterUtil.getValueAsString("collectOperator", modelNode)));
        }
        decisionTable.setPreferredOrientation(DecisionTableOrientation.RULE_AS_ROW);
        LinkedHashMap<String, InputClause> ruleInputContainerMap = new LinkedHashMap<String, InputClause>();
        LinkedHashMap<String, OutputClause> ruleOutputContainerMap = new LinkedHashMap<String, OutputClause>();
        HashMap<String, String> newOldIdMap = new HashMap<String, String>();
        ArrayList<String> complexExpressionIds = new ArrayList<String>();
        this.processInputExpressions(modelNode, ruleInputContainerMap, newOldIdMap, decisionTable);
        this.processOutputExpressions(modelNode, ruleOutputContainerMap, complexExpressionIds, newOldIdMap, decisionTable);
        this.processRules(modelNode, ruleInputContainerMap, ruleOutputContainerMap, complexExpressionIds, newOldIdMap, decisionTable);
        for (InputClause inputClause : decisionTable.getInputs()) {
            if (!StringUtils.isEmpty((CharSequence)inputClause.getInputExpression().getTypeRef())) continue;
            inputClause.getInputExpression().setTypeRef("string");
        }
        for (OutputClause outputClause : decisionTable.getOutputs()) {
            if (!StringUtils.isEmpty((CharSequence)outputClause.getTypeRef())) continue;
            outputClause.setTypeRef("string");
        }
    }

    protected void processInputExpressions(JsonNode modelNode, Map<String, InputClause> ruleInputContainerMap, Map<String, String> newOldIdMap, DecisionTable decisionTable) {
        JsonNode inputExpressions = modelNode.get("inputExpressions");
        if (inputExpressions != null && !inputExpressions.isNull()) {
            for (JsonNode inputExpressionNode : inputExpressions) {
                InputClause inputClause = new InputClause();
                inputClause.setLabel(DmnJsonConverterUtil.getValueAsString("label", inputExpressionNode));
                String oldInputExpressionId = DmnJsonConverterUtil.getValueAsString("id", inputExpressionNode);
                String inputExpressionId = DmnJsonConverterUtil.getUniqueElementId();
                newOldIdMap.put(inputExpressionId, oldInputExpressionId);
                LiteralExpression inputExpression = new LiteralExpression();
                inputExpression.setId("inputExpression_" + inputExpressionId);
                inputExpression.setTypeRef(DmnJsonConverterUtil.getValueAsString("type", inputExpressionNode));
                inputExpression.setLabel(DmnJsonConverterUtil.getValueAsString("label", inputExpressionNode));
                inputExpression.setText(DmnJsonConverterUtil.getValueAsString("variableId", inputExpressionNode));
                inputClause.setInputExpression(inputExpression);
                if (inputExpressionNode.get("entries") != null && !inputExpressionNode.get("entries").isNull() && inputExpressionNode.get("entries").isArray() && inputExpressionNode.get("entries").size() > 0) {
                    UnaryTests inputValues = new UnaryTests();
                    ArrayList<String> inputEntries = new ArrayList<String>();
                    for (JsonNode entriesNode : inputExpressionNode.get("entries")) {
                        inputEntries.add(entriesNode.asText());
                    }
                    inputValues.setTextValues(inputEntries);
                    inputClause.setInputValues(inputValues);
                }
                ruleInputContainerMap.put(inputExpressionId, inputClause);
                decisionTable.addInput(inputClause);
            }
        }
    }

    protected void processOutputExpressions(JsonNode modelNode, Map<String, OutputClause> ruleOutputContainerMap, List<String> complexExpressionIds, Map<String, String> newOldIdMap, DecisionTable decisionTable) {
        JsonNode outputExpressions = modelNode.get("outputExpressions");
        if (outputExpressions != null && !outputExpressions.isNull()) {
            for (JsonNode outputExpressionNode : outputExpressions) {
                OutputClause outputClause = new OutputClause();
                String oldOutputExpressionId = DmnJsonConverterUtil.getValueAsString("id", outputExpressionNode);
                String outputExpressionId = DmnJsonConverterUtil.getUniqueElementId();
                String outputClauseId = "outputExpression_" + outputExpressionId;
                outputClause.setId(outputClauseId);
                newOldIdMap.put(outputExpressionId, oldOutputExpressionId);
                outputClause.setLabel(DmnJsonConverterUtil.getValueAsString("label", outputExpressionNode));
                outputClause.setName(DmnJsonConverterUtil.getValueAsString("variableId", outputExpressionNode));
                outputClause.setTypeRef(DmnJsonConverterUtil.getValueAsString("type", outputExpressionNode));
                if (outputExpressionNode.get("entries") != null && !outputExpressionNode.get("entries").isNull() && outputExpressionNode.get("entries").isArray() && outputExpressionNode.get("entries").size() > 0) {
                    UnaryTests outputValues = new UnaryTests();
                    ArrayList<String> outputEntries = new ArrayList<String>();
                    for (JsonNode entriesNode : outputExpressionNode.get("entries")) {
                        outputEntries.add(entriesNode.asText());
                    }
                    outputValues.setTextValues(outputEntries);
                    outputClause.setOutputValues(outputValues);
                }
                if (outputExpressionNode.get("complexExpression") != null && !outputExpressionNode.get("complexExpression").isNull() && outputExpressionNode.get("complexExpression").asBoolean()) {
                    complexExpressionIds.add(outputExpressionId);
                }
                ruleOutputContainerMap.put(outputExpressionId, outputClause);
                decisionTable.addOutput(outputClause);
            }
        }
    }

    protected void processRules(JsonNode modelNode, Map<String, InputClause> ruleInputContainerMap, Map<String, OutputClause> ruleOutputContainerMap, List<String> complexExpressionIds, Map<String, String> newOldIdMap, DecisionTable decisionTable) {
        JsonNode rules = modelNode.get("rules");
        if (rules != null && !rules.isNull()) {
            int ruleCounter = 1;
            for (JsonNode ruleNode : rules) {
                DecisionRule rule = new DecisionRule();
                for (String id : ruleInputContainerMap.keySet()) {
                    String formattedCollectionExpression;
                    String inputExpressionVariable;
                    JsonNode expressionValueNode;
                    String expressionValue;
                    String oldInputExpressionId = newOldIdMap.get(id);
                    String operatorId = oldInputExpressionId + "_operator";
                    String expressionId = oldInputExpressionId + "_expression";
                    RuleInputClauseContainer ruleInputClauseContainer = new RuleInputClauseContainer();
                    ruleInputClauseContainer.setInputClause(ruleInputContainerMap.get(id));
                    UnaryTests inputEntry = new UnaryTests();
                    inputEntry.setId("inputEntry_" + id + "_" + ruleCounter);
                    JsonNode operatorValueNode = ruleNode.get(operatorId);
                    String operatorValue = null;
                    if (operatorValueNode != null && !operatorValueNode.isNull()) {
                        operatorValue = operatorValueNode.asText();
                    }
                    if ("-".equals(expressionValue = (expressionValueNode = ruleNode.get(expressionId)) == null || expressionValueNode.isNull() ? "-" : expressionValueNode.asText()) || expressionValue.startsWith("${") || expressionValue.startsWith("#{")) {
                        inputEntry.setText(expressionValue);
                    } else if (DmnJsonConverterUtil.isCollectionOperator(operatorValue) && StringUtils.isNotEmpty((CharSequence)expressionValue)) {
                        inputExpressionVariable = ruleInputClauseContainer.getInputClause().getInputExpression().getText();
                        formattedCollectionExpression = "collection".equals(ruleInputClauseContainer.getInputClause().getInputExpression().getTypeRef()) ? DmnJsonConverterUtil.formatCollectionExpression(operatorValue, inputExpressionVariable, expressionValue) : DmnJsonConverterUtil.formatCollectionExpression(operatorValue, expressionValue, inputExpressionVariable);
                        inputEntry.setText(formattedCollectionExpression);
                        this.addExtensionElement("operator", operatorValue, (DmnElement)inputEntry);
                        this.addExtensionElement("expression", expressionValue, (DmnElement)inputEntry);
                    } else if ("collection".equals(ruleInputClauseContainer.getInputClause().getInputExpression().getTypeRef()) && StringUtils.isNotEmpty((CharSequence)expressionValue)) {
                        inputExpressionVariable = ruleInputClauseContainer.getInputClause().getInputExpression().getText();
                        formattedCollectionExpression = DmnJsonConverterUtil.formatCollectionExpression(operatorValue, inputExpressionVariable, expressionValue);
                        inputEntry.setText(formattedCollectionExpression);
                        this.addExtensionElement("operator", operatorValue, (DmnElement)inputEntry);
                        this.addExtensionElement("expression", expressionValue, (DmnElement)inputEntry);
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (StringUtils.isNotEmpty((CharSequence)operatorValue)) {
                            stringBuilder = new StringBuilder(operatorValue);
                            stringBuilder.append(" ");
                        }
                        if ("string".equals(ruleInputClauseContainer.getInputClause().getInputExpression().getTypeRef()) && !expressionValue.startsWith("\"") && !expressionValue.endsWith("\"")) {
                            stringBuilder.append("\"");
                            stringBuilder.append(expressionValue);
                            stringBuilder.append("\"");
                        } else if ("date".equals(ruleInputClauseContainer.getInputClause().getInputExpression().getTypeRef()) && StringUtils.isNotEmpty((CharSequence)expressionValue)) {
                            stringBuilder.append("date:toDate('");
                            stringBuilder.append(expressionValue);
                            stringBuilder.append("')");
                        } else {
                            stringBuilder.append(expressionValue);
                        }
                        inputEntry.setText(stringBuilder.toString());
                    }
                    ruleInputClauseContainer.setInputEntry(inputEntry);
                    rule.addInputEntry(ruleInputClauseContainer);
                }
                for (String id : ruleOutputContainerMap.keySet()) {
                    String oldOutputExpressionId = newOldIdMap.get(id);
                    RuleOutputClauseContainer ruleOutputClauseContainer = new RuleOutputClauseContainer();
                    ruleOutputClauseContainer.setOutputClause(ruleOutputContainerMap.get(id));
                    LiteralExpression outputEntry = new LiteralExpression();
                    outputEntry.setId("outputEntry_" + id + "_" + ruleCounter);
                    if (ruleNode.has(oldOutputExpressionId)) {
                        JsonNode expressionValueNode = ruleNode.get(oldOutputExpressionId);
                        String expressionValue = expressionValueNode == null || expressionValueNode.isNull() ? "" : expressionValueNode.asText();
                        if (complexExpressionIds.contains(id) || expressionValue.startsWith("${") || expressionValue.startsWith("#{")) {
                            outputEntry.setText(expressionValue);
                        } else if ("string".equals(ruleOutputClauseContainer.getOutputClause().getTypeRef()) && !expressionValue.startsWith("\"") && !expressionValue.endsWith("\"")) {
                            outputEntry.setText("\"" + expressionValue + "\"");
                        } else if ("date".equals(ruleOutputClauseContainer.getOutputClause().getTypeRef()) && StringUtils.isNotEmpty((CharSequence)expressionValue)) {
                            outputEntry.setText("date:toDate('" + expressionValue + "')");
                        } else {
                            outputEntry.setText(expressionValue);
                        }
                    } else {
                        outputEntry.setText("");
                    }
                    ruleOutputClauseContainer.setOutputEntry(outputEntry);
                    rule.addOutputEntry(ruleOutputClauseContainer);
                }
                ++ruleCounter;
                decisionTable.addRule(rule);
            }
        }
    }

    protected void addExtensionElement(String name, String value, DmnElement element) {
        DmnExtensionElement extensionElement = new DmnExtensionElement();
        extensionElement.setNamespace(MODEL_NAMESPACE);
        extensionElement.setNamespacePrefix("flowable");
        extensionElement.setName(name);
        extensionElement.setElementText(value);
        element.addExtensionElement(extensionElement);
    }

    protected void addExtensionAttribute(String name, String value, DmnElement element) {
        DmnExtensionAttribute extensionAttribute = new DmnExtensionAttribute();
        extensionAttribute.setNamespace(MODEL_NAMESPACE);
        extensionAttribute.setNamespacePrefix("flowable");
        extensionAttribute.setName(name);
        extensionAttribute.setValue(value);
        element.addAttribute(extensionAttribute);
    }
}

