/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.logging.LoggingSessionUtil;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.DynamicPropertyUtil;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.delegate.ActivityWithMigrationContextBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.IdentityLinkUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.engine.interceptor.CreateUserTaskAfterContext;
import org.flowable.engine.interceptor.CreateUserTaskBeforeContext;
import org.flowable.engine.interceptor.MigrationContext;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.event.impl.FlowableTaskEventBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskActivityBehavior
extends TaskActivityBehavior
implements ActivityWithMigrationContextBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskActivityBehavior.class);
    protected UserTask userTask;

    public UserTaskActivityBehavior(UserTask userTask) {
        this.userTask = userTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        this.execute(execution, null);
    }

    @Override
    public void execute(DelegateExecution execution, MigrationContext migrationContext) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        TaskService taskService = processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        TaskEntity task = taskService.createTask();
        task.setExecutionId(execution.getId());
        task.setTaskDefinitionKey(this.userTask.getId());
        task.setPropagatedStageInstanceId(execution.getPropagatedStageInstanceId());
        String activeTaskName = null;
        String activeTaskDescription = null;
        String activeTaskDueDate = null;
        String activeTaskPriority = null;
        String activeTaskCategory = null;
        String activeTaskFormKey = null;
        String activeTaskSkipExpression = null;
        String activeTaskAssignee = null;
        String activeTaskOwner = null;
        String activeTaskIdVariableName = null;
        List<String> activeTaskCandidateUsers = null;
        List<String> activeTaskCandidateGroups = null;
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        if (processEngineConfiguration.isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.userTask.getId(), execution.getProcessDefinitionId());
            activeTaskName = DynamicPropertyUtil.getActiveValue(this.userTask.getName(), "userTaskName", taskElementProperties);
            activeTaskDescription = DynamicPropertyUtil.getActiveValue(this.userTask.getDocumentation(), "userTaskDescription", taskElementProperties);
            activeTaskDueDate = DynamicPropertyUtil.getActiveValue(this.userTask.getDueDate(), "userTaskDueDate", taskElementProperties);
            activeTaskPriority = DynamicPropertyUtil.getActiveValue(this.userTask.getPriority(), "userTaskPriority", taskElementProperties);
            activeTaskCategory = DynamicPropertyUtil.getActiveValue(this.userTask.getCategory(), "userTaskCategory", taskElementProperties);
            activeTaskFormKey = DynamicPropertyUtil.getActiveValue(this.userTask.getFormKey(), "userTaskFormKey", taskElementProperties);
            activeTaskSkipExpression = DynamicPropertyUtil.getActiveValue(this.userTask.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            activeTaskAssignee = this.getAssigneeValue(this.userTask, migrationContext, taskElementProperties);
            activeTaskOwner = this.getOwnerValue(this.userTask, migrationContext, taskElementProperties);
            activeTaskCandidateUsers = this.getActiveValueList(this.userTask.getCandidateUsers(), "userTaskCandidateUsers", taskElementProperties);
            activeTaskCandidateGroups = this.getActiveValueList(this.userTask.getCandidateGroups(), "userTaskCandidateGroups", taskElementProperties);
            activeTaskIdVariableName = DynamicPropertyUtil.getActiveValue(this.userTask.getTaskIdVariableName(), "taskIdVariableName", taskElementProperties);
        } else {
            activeTaskName = this.userTask.getName();
            activeTaskDescription = this.userTask.getDocumentation();
            activeTaskDueDate = this.userTask.getDueDate();
            activeTaskPriority = this.userTask.getPriority();
            activeTaskCategory = this.userTask.getCategory();
            activeTaskFormKey = this.userTask.getFormKey();
            activeTaskSkipExpression = this.userTask.getSkipExpression();
            activeTaskAssignee = this.getAssigneeValue(this.userTask, migrationContext, null);
            activeTaskOwner = this.getOwnerValue(this.userTask, migrationContext, null);
            activeTaskCandidateUsers = this.userTask.getCandidateUsers();
            activeTaskCandidateGroups = this.userTask.getCandidateGroups();
            activeTaskIdVariableName = this.userTask.getTaskIdVariableName();
        }
        if (execution.getCurrentActivityName() != null) {
            activeTaskName = execution.getCurrentActivityName();
        }
        CreateUserTaskBeforeContext beforeContext = new CreateUserTaskBeforeContext(this.userTask, execution, activeTaskName, activeTaskDescription, activeTaskDueDate, activeTaskPriority, activeTaskCategory, activeTaskFormKey, activeTaskSkipExpression, activeTaskAssignee, activeTaskOwner, activeTaskCandidateUsers, activeTaskCandidateGroups);
        if (processEngineConfiguration.getCreateUserTaskInterceptor() != null) {
            processEngineConfiguration.getCreateUserTaskInterceptor().beforeCreateUserTask(beforeContext);
        }
        this.handleName(beforeContext, expressionManager, task, execution);
        this.handleDescription(beforeContext, expressionManager, task, execution);
        this.handleDueDate(beforeContext, expressionManager, task, execution, processEngineConfiguration, activeTaskDueDate);
        this.handlePriority(beforeContext, expressionManager, task, execution, activeTaskPriority);
        this.handleCategory(beforeContext, expressionManager, task, execution);
        this.handleFormKey(beforeContext, expressionManager, task, execution);
        boolean skipUserTask = SkipExpressionUtil.isSkipExpressionEnabled(beforeContext.getSkipExpression(), this.userTask.getId(), execution, commandContext) && SkipExpressionUtil.shouldSkipFlowElement(beforeContext.getSkipExpression(), this.userTask.getId(), execution, commandContext);
        TaskHelper.insertTask(task, (ExecutionEntity)execution, !skipUserTask, !skipUserTask && processEngineConfiguration.isEnableEntityLinks());
        if (!skipUserTask) {
            Expression expression;
            String idVariableName;
            if (processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addLoggingData("userTaskCreate", "User task '" + task.getName() + "' created", task, execution);
            }
            this.handleAssignments(taskService, beforeContext.getAssignee(), beforeContext.getOwner(), beforeContext.getCandidateUsers(), beforeContext.getCandidateGroups(), task, expressionManager, execution, processEngineConfiguration);
            if (processEngineConfiguration.getCreateUserTaskInterceptor() != null) {
                CreateUserTaskAfterContext afterContext = new CreateUserTaskAfterContext(this.userTask, task, execution);
                processEngineConfiguration.getCreateUserTaskInterceptor().afterCreateUserTask(afterContext);
            }
            try {
                processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(task, "create");
            }
            catch (BpmnError bpmnError) {
                ErrorPropagation.propagateError(bpmnError, execution);
                return;
            }
            FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getTaskServiceConfiguration().getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TASK_CREATED, (Object)task), processEngineConfiguration.getEngineCfgKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)activeTaskIdVariableName) && StringUtils.isNotEmpty((CharSequence)(idVariableName = (String)(expression = expressionManager.createExpression(this.userTask.getTaskIdVariableName())).getValue((VariableContainer)execution)))) {
                execution.setVariable(idVariableName, task.getId());
            }
        } else {
            TaskHelper.deleteTask(task, null, false, false, false);
            this.leave(execution);
        }
    }

    protected void handleName(CreateUserTaskBeforeContext beforeContext, ExpressionManager expressionManager, TaskEntity task, DelegateExecution execution) {
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getName())) {
            String name = null;
            try {
                Object nameValue = expressionManager.createExpression(beforeContext.getName()).getValue((VariableContainer)execution);
                if (nameValue != null) {
                    name = nameValue.toString();
                }
            }
            catch (FlowableException e) {
                name = beforeContext.getName();
                LOGGER.warn("property not found in task name expression {}", (Object)e.getMessage());
            }
            task.setName(name);
        }
    }

    protected void handleDescription(CreateUserTaskBeforeContext beforeContext, ExpressionManager expressionManager, TaskEntity task, DelegateExecution execution) {
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getDescription())) {
            String description = null;
            try {
                Object descriptionValue = expressionManager.createExpression(beforeContext.getDescription()).getValue((VariableContainer)execution);
                if (descriptionValue != null) {
                    description = descriptionValue.toString();
                }
            }
            catch (FlowableException e) {
                description = beforeContext.getDescription();
                LOGGER.warn("property not found in task description expression {}", (Object)e.getMessage());
            }
            task.setDescription(description);
        }
    }

    protected void handleDueDate(CreateUserTaskBeforeContext beforeContext, ExpressionManager expressionManager, TaskEntity task, DelegateExecution execution, ProcessEngineConfigurationImpl processEngineConfiguration, String activeTaskDueDate) {
        Object dueDate;
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getDueDate()) && (dueDate = expressionManager.createExpression(beforeContext.getDueDate()).getValue((VariableContainer)execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                String businessCalendarName = null;
                businessCalendarName = StringUtils.isNotEmpty((CharSequence)this.userTask.getBusinessCalendarName()) ? expressionManager.createExpression(this.userTask.getBusinessCalendarName()).getValue((VariableContainer)execution).toString() : "dueDate";
                BusinessCalendar businessCalendar = processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(businessCalendarName);
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else if (dueDate instanceof Instant) {
                task.setDueDate(Date.from((Instant)dueDate));
            } else if (dueDate instanceof LocalDate) {
                Date localDueDate = Date.from(((LocalDate)dueDate).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                task.setDueDate(localDueDate);
            } else if (dueDate instanceof LocalDateTime) {
                Date localDueDate = Date.from(((LocalDateTime)dueDate).atZone(ZoneId.systemDefault()).toInstant());
                task.setDueDate(localDueDate);
            } else {
                throw new FlowableIllegalArgumentException("Due date expression does not resolve to a Date, Instant, LocalDate, LocalDateTime or Date string: " + beforeContext.getDueDate());
            }
        }
    }

    protected void handlePriority(CreateUserTaskBeforeContext beforeContext, ExpressionManager expressionManager, TaskEntity task, DelegateExecution execution, String activeTaskPriority) {
        Object priority;
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getPriority()) && (priority = expressionManager.createExpression(beforeContext.getPriority()).getValue((VariableContainer)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority).intValue());
                }
                catch (NumberFormatException e) {
                    throw new FlowableIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new FlowableIllegalArgumentException("Priority expression does not resolve to a number: " + activeTaskPriority);
            }
        }
    }

    protected void handleCategory(CreateUserTaskBeforeContext beforeContext, ExpressionManager expressionManager, TaskEntity task, DelegateExecution execution) {
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getCategory())) {
            String category = null;
            try {
                Object categoryValue = expressionManager.createExpression(beforeContext.getCategory()).getValue((VariableContainer)execution);
                if (categoryValue != null) {
                    category = categoryValue.toString();
                }
            }
            catch (FlowableException e) {
                category = beforeContext.getCategory();
                LOGGER.warn("property not found in task category expression {}", (Object)e.getMessage());
            }
            task.setCategory(category);
        }
    }

    protected void handleFormKey(CreateUserTaskBeforeContext beforeContext, ExpressionManager expressionManager, TaskEntity task, DelegateExecution execution) {
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getFormKey())) {
            String formKey = null;
            try {
                Object formKeyValue = expressionManager.createExpression(beforeContext.getFormKey()).getValue((VariableContainer)execution);
                if (formKeyValue != null) {
                    formKey = formKeyValue.toString();
                }
            }
            catch (FlowableException e) {
                formKey = beforeContext.getFormKey();
                LOGGER.warn("property not found in task formKey expression {}", (Object)e.getMessage());
            }
            task.setFormKey(formKey);
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        List taskEntities = processEngineConfiguration.getTaskServiceConfiguration().getTaskService().findTasksByExecutionId(execution.getId());
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.isDeleted()) continue;
            throw new FlowableException("UserTask should not be signalled before complete for " + taskEntity);
        }
        this.leave(execution);
    }

    protected void handleAssignments(TaskService taskService, String assignee, String owner, List<String> candidateUsers, List<String> candidateGroups, TaskEntity task, ExpressionManager expressionManager, DelegateExecution execution, ProcessEngineConfigurationImpl processEngineConfiguration) {
        IdentityLinkEntity identityLinkEntity;
        Object value;
        Expression idExpression;
        ArrayList<IdentityLinkEntity> customIdentityLinkEntities;
        List identityLinkEntities;
        Collection<String> candidates;
        Object value2;
        ArrayList<IdentityLinkEntity> allIdentityLinkEntities;
        ObjectNode loggingNode;
        if (StringUtils.isNotEmpty((CharSequence)assignee)) {
            Object assigneeExpressionValue = expressionManager.createExpression(assignee).getValue((VariableContainer)execution);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            if (StringUtils.isNotEmpty(assigneeValue)) {
                TaskHelper.changeTaskAssignee(task, assigneeValue);
                if (processEngineConfiguration.isLoggingSessionEnabled()) {
                    loggingNode = BpmnLoggingSessionUtil.fillBasicTaskLoggingData("Set task assignee value to " + assigneeValue, task, execution);
                    loggingNode.put("taskAssignee", assigneeValue);
                    LoggingSessionUtil.addLoggingData((String)"userTaskSetAssignee", (ObjectNode)loggingNode, (String)"bpmn");
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)owner)) {
            Object ownerExpressionValue = expressionManager.createExpression(owner).getValue((VariableContainer)execution);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            if (StringUtils.isNotEmpty(ownerValue)) {
                TaskHelper.changeTaskOwner(task, ownerValue);
                if (processEngineConfiguration.isLoggingSessionEnabled()) {
                    loggingNode = BpmnLoggingSessionUtil.fillBasicTaskLoggingData("Set task owner value to " + ownerValue, task, execution);
                    loggingNode.put("taskOwner", ownerValue);
                    LoggingSessionUtil.addLoggingData((String)"userTaskSetOwner", (ObjectNode)loggingNode, (String)"bpmn");
                }
            }
        }
        if (candidateGroups != null && !candidateGroups.isEmpty()) {
            allIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
            for (String candidateGroup : candidateGroups) {
                Expression groupIdExpr = expressionManager.createExpression(candidateGroup);
                value2 = groupIdExpr.getValue((VariableContainer)execution);
                if (value2 == null) continue;
                candidates = this.extractCandidates(value2);
                identityLinkEntities = processEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().addCandidateGroups(task.getId(), candidates);
                if (identityLinkEntities == null || identityLinkEntities.isEmpty()) continue;
                IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities);
                allIdentityLinkEntities.addAll(identityLinkEntities);
            }
            if (!allIdentityLinkEntities.isEmpty() && processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addTaskIdentityLinkData("userTaskSetGroupIdentityLinks", "Added " + allIdentityLinkEntities.size() + " candidate group identity links to task", false, allIdentityLinkEntities, task, execution);
            }
        }
        if (candidateUsers != null && !candidateUsers.isEmpty()) {
            allIdentityLinkEntities = new ArrayList();
            for (String candidateUser : candidateUsers) {
                Expression userIdExpr = expressionManager.createExpression(candidateUser);
                value2 = userIdExpr.getValue((VariableContainer)execution);
                if (value2 == null) continue;
                candidates = this.extractCandidates(value2);
                identityLinkEntities = processEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().addCandidateUsers(task.getId(), candidates);
                if (identityLinkEntities == null || identityLinkEntities.isEmpty()) continue;
                IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities);
                allIdentityLinkEntities.addAll(identityLinkEntities);
            }
            if (!allIdentityLinkEntities.isEmpty() && processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addTaskIdentityLinkData("userTaskSetUserIdentityLinks", "Added " + allIdentityLinkEntities.size() + " candidate user identity links to task", true, allIdentityLinkEntities, task, execution);
            }
        }
        if (this.userTask.getCustomUserIdentityLinks() != null && !this.userTask.getCustomUserIdentityLinks().isEmpty()) {
            customIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
            for (String customUserIdentityLinkType : this.userTask.getCustomUserIdentityLinks().keySet()) {
                for (String userIdentityLink : (Set)this.userTask.getCustomUserIdentityLinks().get(customUserIdentityLinkType)) {
                    idExpression = expressionManager.createExpression(userIdentityLink);
                    value = idExpression.getValue((VariableContainer)execution);
                    Collection<String> userIds = this.extractCandidates(value);
                    for (String userId : userIds) {
                        identityLinkEntity = processEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().createTaskIdentityLink(task.getId(), userId, null, customUserIdentityLinkType);
                        IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity);
                        customIdentityLinkEntities.add(identityLinkEntity);
                    }
                }
            }
            if (!customIdentityLinkEntities.isEmpty() && processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addTaskIdentityLinkData("userTaskSetUserIdentityLinks", "Added " + customIdentityLinkEntities.size() + " custom user identity links to task", true, customIdentityLinkEntities, task, execution);
            }
        }
        if (this.userTask.getCustomGroupIdentityLinks() != null && !this.userTask.getCustomGroupIdentityLinks().isEmpty()) {
            customIdentityLinkEntities = new ArrayList();
            for (String customGroupIdentityLinkType : this.userTask.getCustomGroupIdentityLinks().keySet()) {
                for (String groupIdentityLink : (Set)this.userTask.getCustomGroupIdentityLinks().get(customGroupIdentityLinkType)) {
                    idExpression = expressionManager.createExpression(groupIdentityLink);
                    value = idExpression.getValue((VariableContainer)execution);
                    Collection<String> groupIds = this.extractCandidates(value);
                    for (String groupId : groupIds) {
                        identityLinkEntity = processEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().createTaskIdentityLink(task.getId(), null, groupId, customGroupIdentityLinkType);
                        IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity);
                        customIdentityLinkEntities.add(identityLinkEntity);
                    }
                }
            }
            if (!customIdentityLinkEntities.isEmpty() && processEngineConfiguration.isLoggingSessionEnabled()) {
                BpmnLoggingSessionUtil.addTaskIdentityLinkData("userTaskSetGroupIdentityLinks", "Added " + customIdentityLinkEntities.size() + " custom group identity links to task", false, customIdentityLinkEntities, task, execution);
            }
        }
    }

    protected Collection<String> extractCandidates(Object value) {
        String str;
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof ArrayNode) {
            ArrayNode valueArrayNode = (ArrayNode)value;
            ArrayList<String> candidates = new ArrayList<String>(valueArrayNode.size());
            for (JsonNode node : valueArrayNode) {
                candidates.add(node.asText());
            }
            return candidates;
        }
        if (value != null && StringUtils.isNotEmpty((CharSequence)(str = value.toString()))) {
            return Arrays.asList(value.toString().split("[\\s]*,[\\s]*"));
        }
        return Collections.emptyList();
    }

    protected String getAssigneeValue(UserTask userTask, MigrationContext migrationContext, ObjectNode taskElementProperties) {
        if (migrationContext != null && migrationContext.getAssignee() != null) {
            return migrationContext.getAssignee();
        }
        if (taskElementProperties != null) {
            return DynamicPropertyUtil.getActiveValue(userTask.getAssignee(), "userTaskAssignee", taskElementProperties);
        }
        return userTask.getAssignee();
    }

    protected String getOwnerValue(UserTask userTask, MigrationContext migrationContext, ObjectNode taskElementProperties) {
        if (migrationContext != null && migrationContext.getOwner() != null) {
            return migrationContext.getOwner();
        }
        if (taskElementProperties != null) {
            return DynamicPropertyUtil.getActiveValue(userTask.getOwner(), "userTaskOwner", taskElementProperties);
        }
        return userTask.getOwner();
    }
}

