/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl;

import java.util.Date;
import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.query.QueryProperty;
import org.flowable.engine.common.impl.AbstractQuery;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.idm.api.Token;
import org.flowable.idm.api.TokenQuery;
import org.flowable.idm.api.TokenQueryProperty;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class TokenQueryImpl
extends AbstractQuery<TokenQuery, Token>
implements TokenQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected List<String> ids;
    protected String tokenValue;
    protected Date tokenDate;
    protected Date tokenDateBefore;
    protected Date tokenDateAfter;
    protected String ipAddress;
    protected String ipAddressLike;
    protected String userAgent;
    protected String userAgentLike;
    protected String userId;
    protected String userIdLike;
    protected String tokenData;
    protected String tokenDataLike;

    public TokenQueryImpl() {
    }

    public TokenQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public TokenQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public TokenQuery tokenId(String id) {
        if (id == null) {
            throw new FlowableIllegalArgumentException("Provided id is null");
        }
        this.id = id;
        return this;
    }

    public TokenQuery tokenIds(List<String> ids) {
        if (ids == null) {
            throw new FlowableIllegalArgumentException("Provided ids is null");
        }
        this.ids = ids;
        return this;
    }

    public TokenQuery tokenValue(String tokenValue) {
        if (tokenValue == null) {
            throw new FlowableIllegalArgumentException("Provided token value is null");
        }
        this.tokenValue = tokenValue;
        return this;
    }

    public TokenQuery tokenDate(Date tokenDate) {
        if (tokenDate == null) {
            throw new FlowableIllegalArgumentException("Provided token date is null");
        }
        this.tokenDate = tokenDate;
        return this;
    }

    public TokenQuery tokenDateBefore(Date tokenDateBefore) {
        if (tokenDateBefore == null) {
            throw new FlowableIllegalArgumentException("Provided tokenDateBefore is null");
        }
        this.tokenDateBefore = tokenDateBefore;
        return this;
    }

    public TokenQuery tokenDateAfter(Date tokenDateAfter) {
        if (tokenDateAfter == null) {
            throw new FlowableIllegalArgumentException("Provided tokenDateAfter is null");
        }
        this.tokenDateAfter = tokenDateAfter;
        return this;
    }

    public TokenQuery ipAddress(String ipAddress) {
        if (ipAddress == null) {
            throw new FlowableIllegalArgumentException("Provided ip address is null");
        }
        this.ipAddress = ipAddress;
        return this;
    }

    public TokenQuery ipAddressLike(String ipAddressLike) {
        if (ipAddressLike == null) {
            throw new FlowableIllegalArgumentException("Provided ipAddressLike is null");
        }
        this.ipAddressLike = ipAddressLike;
        return this;
    }

    public TokenQuery userAgent(String userAgent) {
        if (userAgent == null) {
            throw new FlowableIllegalArgumentException("Provided user agent is null");
        }
        this.userAgent = userAgent;
        return this;
    }

    public TokenQuery userAgentLike(String userAgentLike) {
        if (userAgentLike == null) {
            throw new FlowableIllegalArgumentException("Provided userAgentLike is null");
        }
        this.userAgentLike = userAgentLike;
        return this;
    }

    public TokenQuery userId(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("Provided user id is null");
        }
        this.userId = userId;
        return this;
    }

    public TokenQuery userIdLike(String userIdLike) {
        if (userIdLike == null) {
            throw new FlowableIllegalArgumentException("Provided userIdLike is null");
        }
        this.userIdLike = userIdLike;
        return this;
    }

    public TokenQuery tokenData(String tokenData) {
        if (tokenData == null) {
            throw new FlowableIllegalArgumentException("Provided token data is null");
        }
        this.tokenData = tokenData;
        return this;
    }

    public TokenQuery tokenDataLike(String tokenDataLike) {
        if (tokenDataLike == null) {
            throw new FlowableIllegalArgumentException("Provided tokenDataLike is null");
        }
        this.tokenDataLike = tokenDataLike;
        return this;
    }

    public TokenQuery orderByTokenId() {
        return (TokenQuery)this.orderBy((QueryProperty)TokenQueryProperty.TOKEN_ID);
    }

    public TokenQuery orderByTokenDate() {
        return (TokenQuery)this.orderBy((QueryProperty)TokenQueryProperty.TOKEN_DATE);
    }

    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getTokenEntityManager(commandContext).findTokenCountByQueryCriteria(this);
    }

    public List<Token> executeList(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getTokenEntityManager(commandContext).findTokenByQueryCriteria(this);
    }

    public String getId() {
        return this.id;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public Date getTokenDate() {
        return this.tokenDate;
    }

    public Date getTokenDateBefore() {
        return this.tokenDateBefore;
    }

    public Date getTokenDateAfter() {
        return this.tokenDateAfter;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getIpAddressLike() {
        return this.ipAddressLike;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getUserAgentLike() {
        return this.userAgentLike;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserIdLike() {
        return this.userIdLike;
    }

    public String getTokenData() {
        return this.tokenData;
    }

    public String getTokenDataLike() {
        return this.tokenDataLike;
    }
}

