/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.engine.impl.persistence.entity.PrivilegeEntity;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class CreatePrivilegeCmd
implements Command<Privilege>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;

    public CreatePrivilegeCmd(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("Privilege name is null");
        }
        this.name = name;
    }

    public Privilege execute(CommandContext commandContext) {
        long count = CommandContextUtil.getPrivilegeEntityManager(commandContext).createNewPrivilegeQuery().privilegeName(this.name).count();
        if (count > 0L) {
            throw new FlowableIllegalArgumentException("Provided privilege name already exists");
        }
        PrivilegeEntity entity = (PrivilegeEntity)CommandContextUtil.getPrivilegeEntityManager(commandContext).create();
        entity.setName(this.name);
        CommandContextUtil.getPrivilegeEntityManager(commandContext).insert(entity);
        return entity;
    }
}

