/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.idm.api.Picture;
import org.flowable.idm.api.User;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class SetUserPictureCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected Picture picture;

    public SetUserPictureCmd(String userId, Picture picture) {
        this.userId = userId;
        this.picture = picture;
    }

    public Object execute(CommandContext commandContext) {
        if (this.userId == null) {
            throw new FlowableIllegalArgumentException("userId is null");
        }
        User user = (User)CommandContextUtil.getIdmEngineConfiguration().getIdmIdentityService().createUserQuery().userId(this.userId).singleResult();
        if (user == null) {
            throw new FlowableObjectNotFoundException("user " + this.userId + " doesn't exist", User.class);
        }
        CommandContextUtil.getUserEntityManager(commandContext).setUserPicture(user, this.picture);
        return null;
    }
}

