/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.flowable.engine.common.impl.db.HasRevision;
import org.flowable.engine.common.impl.persistence.entity.AbstractEntity;
import org.flowable.idm.api.Picture;
import org.flowable.idm.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.idm.engine.impl.persistence.entity.UserEntity;

public class UserEntityImpl
extends AbstractEntity
implements UserEntity,
Serializable,
HasRevision {
    private static final long serialVersionUID = 1L;
    protected String firstName;
    protected String lastName;
    protected String email;
    protected String password;
    protected String tenantId;
    protected ByteArrayRef pictureByteArrayRef;

    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("firstName", this.firstName);
        persistentState.put("lastName", this.lastName);
        persistentState.put("email", this.email);
        persistentState.put("password", this.password);
        persistentState.put("tenantId", this.tenantId);
        if (this.pictureByteArrayRef != null) {
            persistentState.put("pictureByteArrayId", this.pictureByteArrayRef.getId());
        }
        return persistentState;
    }

    @Override
    public Picture getPicture() {
        if (this.pictureByteArrayRef != null && this.pictureByteArrayRef.getId() != null) {
            return new Picture(this.pictureByteArrayRef.getBytes(), this.pictureByteArrayRef.getName());
        }
        return null;
    }

    @Override
    public void setPicture(Picture picture) {
        if (picture != null) {
            this.savePicture(picture);
        } else {
            this.deletePicture();
        }
    }

    protected void savePicture(Picture picture) {
        if (this.pictureByteArrayRef == null) {
            this.pictureByteArrayRef = new ByteArrayRef();
        }
        this.pictureByteArrayRef.setValue(picture.getMimeType(), picture.getBytes());
    }

    protected void deletePicture() {
        if (this.pictureByteArrayRef != null) {
            this.pictureByteArrayRef.delete();
        }
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isPictureSet() {
        return this.pictureByteArrayRef != null && this.pictureByteArrayRef.getId() != null;
    }

    @Override
    public ByteArrayRef getPictureByteArrayRef() {
        return this.pictureByteArrayRef;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}

