/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.test;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.flowable.engine.common.impl.db.DbSchemaManager;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.IdmManagementService;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.util.CommandContextUtil;
import org.flowable.idm.engine.test.AbstractTestCase;
import org.junit.Assert;

public abstract class AbstractFlowableIdmTestCase
extends AbstractTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = Collections.singletonList("ACT_ID_PROPERTY");
    protected IdmEngine idmEngine;
    protected Throwable exception;
    protected IdmEngineConfiguration idmEngineConfiguration;
    protected IdmIdentityService idmIdentityService;
    protected IdmManagementService idmManagementService;

    protected abstract void initializeIdmEngine();

    protected void closeDownIdmEngine() {
    }

    public void runBare() throws Throwable {
        this.initializeIdmEngine();
        if (this.idmIdentityService == null) {
            this.initializeServices();
        }
        try {
            super.runBare();
        }
        catch (AssertionFailedError e) {
            LOGGER.error("\n");
            LOGGER.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("\n");
            LOGGER.error("EXCEPTION: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        finally {
            this.assertAndEnsureCleanDb();
            this.idmEngineConfiguration.getClock().reset();
            this.closeDownIdmEngine();
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        LOGGER.debug("verifying that db is clean after test");
        Map tableCounts = this.idmManagementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(this.idmEngineConfiguration.getDatabaseTablePrefix(), "");
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix) || (count = (Long)tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            LOGGER.error("\n");
            LOGGER.error(outputMessage.toString());
            LOGGER.info("dropping and recreating db");
            CommandExecutor commandExecutor = this.idmEngine.getIdmEngineConfiguration().getCommandExecutor();
            CommandConfig config = new CommandConfig().transactionNotSupported();
            commandExecutor.execute(config, (Command)new Command<Object>(){

                public Object execute(CommandContext commandContext) {
                    DbSchemaManager dbSchemaManager = CommandContextUtil.getIdmEngineConfiguration(commandContext).getDbSchemaManager();
                    dbSchemaManager.dbSchemaCreate();
                    dbSchemaManager.dbSchemaDrop();
                    return null;
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            Assert.fail((String)outputMessage.toString());
        } else {
            LOGGER.info("database was clean");
        }
    }

    protected void initializeServices() {
        this.idmEngineConfiguration = this.idmEngine.getIdmEngineConfiguration();
        this.idmIdentityService = this.idmEngine.getIdmIdentityService();
        this.idmManagementService = this.idmEngine.getIdmManagementService();
    }
}

