/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.job.service;

import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncRunnableExecutionExceptionHandler;
import org.flowable.job.service.impl.asyncexecutor.ResetExpiredJobsRunnable;
import org.flowable.job.service.impl.asyncexecutor.UnacquireAsyncHistoryJobExceptionHandler;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.flowable.spring.job.service.SpringAsyncExecutor;

public class SpringAsyncHistoryExecutor
extends SpringAsyncExecutor {
    public SpringAsyncHistoryExecutor() {
        this.init();
    }

    protected void init() {
        this.setTimerRunnableNeeded(false);
        this.setAcquireRunnableThreadName("flowable-acquire-history-jobs");
        this.setResetExpiredRunnableName("flowable-reset-expired-history-jobs");
        this.setAsyncRunnableExecutionExceptionHandler((AsyncRunnableExecutionExceptionHandler)new UnacquireAsyncHistoryJobExceptionHandler());
    }

    protected void initializeJobEntityManager() {
        if (this.jobEntityManager == null) {
            this.jobEntityManager = this.jobServiceConfiguration.getHistoryJobEntityManager();
        }
    }

    protected ResetExpiredJobsRunnable createResetExpiredJobsRunnable(String resetRunnableName) {
        return new ResetExpiredJobsRunnable(resetRunnableName, (AsyncExecutor)this, new JobInfoEntityManager[]{this.jobServiceConfiguration.getHistoryJobEntityManager()});
    }
}

