/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ldap.impl;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.idm.api.User;
import org.flowable.idm.engine.impl.UserQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.UserEntity;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityImpl;
import org.flowable.ldap.LDAPCallBack;
import org.flowable.ldap.LDAPConfiguration;
import org.flowable.ldap.LDAPTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPUserQueryImpl
extends UserQueryImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LDAPUserQueryImpl.class);
    protected LDAPConfiguration ldapConfigurator;

    public LDAPUserQueryImpl(LDAPConfiguration ldapConfigurator) {
        this.ldapConfigurator = ldapConfigurator;
    }

    public long executeCount(CommandContext commandContext) {
        return this.executeQuery().size();
    }

    public List<User> executeList(CommandContext commandContext) {
        return this.executeQuery();
    }

    protected List<User> executeQuery() {
        if (this.getId() != null) {
            ArrayList<User> result = new ArrayList<User>();
            result.add((User)this.findById(this.getId()));
            return result;
        }
        if (this.getIdIgnoreCase() != null) {
            ArrayList<User> result = new ArrayList<User>();
            result.add((User)this.findById(this.getIdIgnoreCase()));
            return result;
        }
        if (this.getFullNameLike() != null) {
            return this.executeNameQuery(this.getFullNameLike());
        }
        if (this.getFullNameLikeIgnoreCase() != null) {
            return this.executeNameQuery(this.getFullNameLikeIgnoreCase());
        }
        return this.executeAllUserQuery();
    }

    protected List<User> executeNameQuery(String name) {
        String fullName = name.replaceAll("%", "");
        String searchExpression = this.ldapConfigurator.getLdapQueryBuilder().buildQueryByFullNameLike(this.ldapConfigurator, fullName);
        return this.executeUsersQuery(searchExpression);
    }

    protected List<User> executeAllUserQuery() {
        String searchExpression = this.ldapConfigurator.getQueryAllUsers();
        return this.executeUsersQuery(searchExpression);
    }

    protected UserEntity findById(final String userId) {
        LDAPTemplate ldapTemplate = new LDAPTemplate(this.ldapConfigurator);
        return ldapTemplate.execute(new LDAPCallBack<UserEntity>(){

            @Override
            public UserEntity executeInContext(InitialDirContext initialDirContext) {
                try {
                    String searchExpression = LDAPUserQueryImpl.this.ldapConfigurator.getLdapQueryBuilder().buildQueryByUserId(LDAPUserQueryImpl.this.ldapConfigurator, userId);
                    String baseDn = LDAPUserQueryImpl.this.ldapConfigurator.getUserBaseDn() != null ? LDAPUserQueryImpl.this.ldapConfigurator.getUserBaseDn() : LDAPUserQueryImpl.this.ldapConfigurator.getBaseDn();
                    NamingEnumeration<SearchResult> namingEnum = initialDirContext.search(baseDn, searchExpression, LDAPUserQueryImpl.this.createSearchControls());
                    UserEntityImpl user = new UserEntityImpl();
                    while (namingEnum.hasMore()) {
                        SearchResult result = namingEnum.next();
                        LDAPUserQueryImpl.this.mapSearchResultToUser(result, (UserEntity)user);
                    }
                    namingEnum.close();
                    return user;
                }
                catch (NamingException ne) {
                    LOGGER.error("Could not find user {} : {}", new Object[]{userId, ne.getMessage(), ne});
                    return null;
                }
            }
        });
    }

    protected List<User> executeUsersQuery(final String searchExpression) {
        LDAPTemplate ldapTemplate = new LDAPTemplate(this.ldapConfigurator);
        return ldapTemplate.execute(new LDAPCallBack<List<User>>(){

            @Override
            public List<User> executeInContext(InitialDirContext initialDirContext) {
                ArrayList<User> result = new ArrayList<User>();
                try {
                    String baseDn = LDAPUserQueryImpl.this.ldapConfigurator.getUserBaseDn() != null ? LDAPUserQueryImpl.this.ldapConfigurator.getUserBaseDn() : LDAPUserQueryImpl.this.ldapConfigurator.getBaseDn();
                    NamingEnumeration<SearchResult> namingEnum = initialDirContext.search(baseDn, searchExpression, LDAPUserQueryImpl.this.createSearchControls());
                    while (namingEnum.hasMore()) {
                        SearchResult searchResult = namingEnum.next();
                        UserEntityImpl user = new UserEntityImpl();
                        LDAPUserQueryImpl.this.mapSearchResultToUser(searchResult, (UserEntity)user);
                        result.add((User)user);
                    }
                    namingEnum.close();
                }
                catch (NamingException ne) {
                    LOGGER.debug("Could not execute LDAP query: {}", (Object)ne.getMessage(), (Object)ne);
                    return null;
                }
                return result;
            }
        });
    }

    protected void mapSearchResultToUser(SearchResult result, UserEntity user) throws NamingException {
        if (this.ldapConfigurator.getUserIdAttribute() != null) {
            user.setId(result.getAttributes().get(this.ldapConfigurator.getUserIdAttribute()).get().toString());
        }
        if (this.ldapConfigurator.getUserFirstNameAttribute() != null) {
            try {
                user.setFirstName(result.getAttributes().get(this.ldapConfigurator.getUserFirstNameAttribute()).get().toString());
            }
            catch (NullPointerException e) {
                user.setFirstName("");
            }
        }
        if (this.ldapConfigurator.getUserLastNameAttribute() != null) {
            try {
                user.setLastName(result.getAttributes().get(this.ldapConfigurator.getUserLastNameAttribute()).get().toString());
            }
            catch (NullPointerException e) {
                user.setLastName("");
            }
        }
        if (this.ldapConfigurator.getUserEmailAttribute() != null) {
            try {
                user.setEmail(result.getAttributes().get(this.ldapConfigurator.getUserEmailAttribute()).get().toString());
            }
            catch (NullPointerException e) {
                user.setEmail("");
            }
        }
    }

    protected SearchControls createSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(this.ldapConfigurator.getSearchTimeLimit());
        return searchControls;
    }
}

