/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service.keycloak;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.idm.api.User;
import org.flowable.idm.engine.impl.UserQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityImpl;
import org.flowable.ui.idm.service.keycloak.KeycloakConfiguration;
import org.flowable.ui.idm.service.keycloak.KeycloakUserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.util.UriComponentsBuilder;

public class KeycloakUserQueryImpl
extends UserQueryImpl {
    protected static final ParameterizedTypeReference<List<KeycloakUserRepresentation>> KEYCLOAK_LIST_OF_USERS = new ParameterizedTypeReference<List<KeycloakUserRepresentation>>(){};
    protected static final Logger LOGGER = LoggerFactory.getLogger(KeycloakUserQueryImpl.class);
    protected KeycloakConfiguration keycloakConfiguration;

    public KeycloakUserQueryImpl(KeycloakConfiguration keycloakConfiguration) {
        this.keycloakConfiguration = keycloakConfiguration;
    }

    public long executeCount(CommandContext commandContext) {
        UriComponentsBuilder builder = this.prepareQuery("/users/count");
        URI uri = builder.buildAndExpand(new Object[]{this.keycloakConfiguration.getRealm()}).toUri();
        ResponseEntity response = this.keycloakConfiguration.getRestTemplate().getForEntity(uri, Long.class);
        HttpStatus statusCode = response.getStatusCode();
        if (statusCode.is2xxSuccessful()) {
            LOGGER.debug("Successful response from keycloak");
            Long usersCount = (Long)response.getBody();
            if (usersCount != null) {
                return usersCount;
            }
            LOGGER.warn("Keycloak didn't return any body when querying users");
            return 0L;
        }
        throw new FlowableException("Keycloak returned status code: " + statusCode);
    }

    public List<User> executeList(CommandContext commandContext) {
        UriComponentsBuilder builder = this.prepareQuery("/users");
        if (this.getMaxResults() >= 0) {
            builder.queryParam("max", new Object[]{this.getMaxResults()});
        }
        if (this.getFirstResult() >= 0) {
            builder.queryParam("first", new Object[]{this.getFirstResult()});
        }
        URI uri = builder.buildAndExpand(new Object[]{this.keycloakConfiguration.getRealm()}).toUri();
        ResponseEntity response = this.keycloakConfiguration.getRestTemplate().exchange(uri, HttpMethod.GET, null, KEYCLOAK_LIST_OF_USERS);
        HttpStatus statusCode = response.getStatusCode();
        if (statusCode.is2xxSuccessful()) {
            LOGGER.debug("Successful response from keycloak");
            List keycloakUsers = (List)response.getBody();
            if (keycloakUsers != null) {
                ArrayList<User> users = new ArrayList<User>(keycloakUsers.size());
                for (KeycloakUserRepresentation keycloakUser : keycloakUsers) {
                    UserEntityImpl user = new UserEntityImpl();
                    user.setId(keycloakUser.getUsername());
                    user.setFirstName(keycloakUser.getFirstName());
                    user.setLastName(keycloakUser.getLastName());
                    user.setEmail(keycloakUser.getEmail());
                    users.add((User)user);
                }
                return users;
            }
            LOGGER.warn("Keycloak didn't return any body when querying users");
            return Collections.emptyList();
        }
        throw new FlowableException("Keycloak returned status code: " + statusCode);
    }

    protected UriComponentsBuilder prepareQuery(String path) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.keycloakConfiguration.getServer() + "auth/admin/realms/{realm}" + path));
        if (this.getId() != null) {
            builder.queryParam("username", new Object[]{this.getId()});
        } else if (this.getIdIgnoreCase() != null) {
            builder.queryParam("username", new Object[]{this.getIdIgnoreCase()});
        } else if (this.getFullNameLike() != null) {
            builder.queryParam("search", new Object[]{this.getFullNameLike()});
        } else if (this.getFullNameLikeIgnoreCase() != null) {
            builder.queryParam("search", new Object[]{this.getFullNameLikeIgnoreCase()});
        }
        return builder;
    }
}

