/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.rest.app;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.flowable.idm.api.Group;
import org.flowable.ui.common.model.GroupRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.exception.UnauthorizedException;
import org.flowable.ui.idm.model.UserInformation;
import org.flowable.ui.idm.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class AccountResource {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"/rest/authenticate"}, method={RequestMethod.GET}, produces={"application/json"})
    public ObjectNode isAuthenticated(HttpServletRequest request) {
        String user = request.getRemoteUser();
        if (user == null) {
            throw new UnauthorizedException("Request did not contain valid authorization");
        }
        ObjectNode result = this.objectMapper.createObjectNode();
        result.put("login", user);
        return result;
    }

    @RequestMapping(value={"/rest/account"}, method={RequestMethod.GET}, produces={"application/json"})
    public UserRepresentation getAccount() {
        String userId = SecurityUtils.getCurrentFlowableAppUser().getUserObject().getId();
        UserInformation userInformation = this.userService.getUserInformation(userId);
        if (userInformation != null) {
            UserRepresentation userRepresentation = new UserRepresentation(userInformation.getUser());
            if (userInformation.getGroups() != null) {
                for (Group group : userInformation.getGroups()) {
                    userRepresentation.getGroups().add(new GroupRepresentation(group));
                }
            }
            if (userInformation.getPrivileges() != null) {
                for (String privilege : userInformation.getPrivileges()) {
                    userRepresentation.getPrivileges().add(privilege);
                }
            }
            return userRepresentation;
        }
        throw new NotFoundException();
    }
}

