/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.conf;

import java.util.Collections;
import org.flowable.ui.common.filter.FlowableCookieFilterRegistrationBean;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.properties.FlowableRestAppProperties;
import org.flowable.ui.common.security.ActuatorRequestMatcher;
import org.flowable.ui.common.security.ClearFlowableCookieLogoutHandler;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.flowable.ui.modeler.properties.FlowableModelerAppProperties;
import org.flowable.ui.modeler.security.AjaxLogoutSuccessHandler;
import org.flowable.ui.modeler.security.RemoteIdmAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfiguration.class);
    public static final String REST_ENDPOINTS_PREFIX = "/app/rest";
    @Autowired
    protected RemoteIdmAuthenticationProvider authenticationProvider;

    @Bean
    public FlowableCookieFilterRegistrationBean flowableCookieFilterRegistrationBean(RemoteIdmService remoteIdmService, FlowableCommonAppProperties properties) {
        FlowableCookieFilterRegistrationBean filter = new FlowableCookieFilterRegistrationBean(remoteIdmService, properties);
        filter.addUrlPatterns(new String[]{"/app/*"});
        filter.setRequiredPrivileges(Collections.singletonList("access-modeler"));
        return filter;
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        try {
            auth.authenticationProvider((AuthenticationProvider)this.authenticationProvider);
        }
        catch (Exception e) {
            LOGGER.error("Could not configure authentication mechanism:", (Throwable)e);
        }
    }

    @ConditionalOnClass(value={EndpointRequest.class})
    @Configuration
    @Order(value=5)
    public static class ActuatorWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable();
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.requestMatcher((RequestMatcher)new ActuatorRequestMatcher()).authorizeRequests().requestMatchers(new RequestMatcher[]{EndpointRequest.to((Class[])new Class[]{InfoEndpoint.class, HealthEndpoint.class})})).authenticated().requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint()})).hasAnyAuthority(new String[]{"access-admin"}).and()).httpBasic();
        }
    }

    @Configuration
    @Order(value=1)
    public static class ApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected final FlowableRestAppProperties restAppProperties;
        protected final FlowableModelerAppProperties modelerAppProperties;

        public ApiWebSecurityConfigurationAdapter(FlowableRestAppProperties restAppProperties, FlowableModelerAppProperties modelerAppProperties) {
            this.restAppProperties = restAppProperties;
            this.modelerAppProperties = modelerAppProperties;
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable();
            if (this.modelerAppProperties.isRestEnabled()) {
                if (this.restAppProperties.isVerifyRestApiPrivilege()) {
                    ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/**").authorizeRequests().antMatchers(new String[]{"/api/**"})).hasAuthority("access-rest-api").and()).httpBasic();
                } else {
                    ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/**").authorizeRequests().antMatchers(new String[]{"/api/**"})).authenticated().and()).httpBasic();
                }
            } else {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/**").authorizeRequests().antMatchers(new String[]{"/api/**"})).denyAll();
            }
        }
    }

    @Configuration
    @Order(value=10)
    public static class FormLoginWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        protected FlowableCookieFilterRegistrationBean flowableCookieFilterRegistrationBean;
        @Autowired
        protected AjaxLogoutSuccessHandler ajaxLogoutSuccessHandler;

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).addFilterBefore(this.flowableCookieFilterRegistrationBean.getFilter(), UsernamePasswordAuthenticationFilter.class).logout().logoutUrl("/app/logout").logoutSuccessHandler((LogoutSuccessHandler)this.ajaxLogoutSuccessHandler).addLogoutHandler((LogoutHandler)new ClearFlowableCookieLogoutHandler()).and()).csrf().disable()).headers().frameOptions().sameOrigin().addHeaderWriter((HeaderWriter)new XXssProtectionHeaderWriter()).and()).authorizeRequests().antMatchers(new String[]{"/app/rest/**"})).hasAuthority("access-modeler");
        }
    }
}

