/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.DeployKey;

public class DeployKeysApi
extends AbstractApi {
    public DeployKeysApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<DeployKey> getDeployKeys() throws GitLabApiException {
        return this.getDeployKeys(1, this.getDefaultPerPage());
    }

    public List<DeployKey> getDeployKeys(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "deploy_keys");
        return (List)response.readEntity((GenericType)new GenericType<List<DeployKey>>(){});
    }

    public Pager<DeployKey> getDeployKeys(int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployKey>(this, DeployKey.class, itemsPerPage, null, "deploy_keys");
    }

    public List<DeployKey> getProjectDeployKeys(Integer projectId) throws GitLabApiException {
        return this.getProjectDeployKeys(projectId, 1, this.getDefaultPerPage());
    }

    public List<DeployKey> getProjectDeployKeys(Integer projectId, int page, int perPage) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "deploy_keys");
        return (List)response.readEntity((GenericType)new GenericType<List<DeployKey>>(){});
    }

    public Pager<DeployKey> getProjectDeployKeys(Integer projectId, Integer itemsPerPage) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        return new Pager<DeployKey>(this, DeployKey.class, itemsPerPage, null, "projects", projectId, "deploy_keys");
    }

    public DeployKey getDeployKey(Integer projectId, Integer keyId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "deploy_keys", keyId);
        return (DeployKey)response.readEntity(DeployKey.class);
    }

    public Optional<DeployKey> getOptionalDeployKey(Integer projectId, Integer keyId) {
        try {
            return Optional.ofNullable(this.getDeployKey(projectId, keyId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public DeployKey addDeployKey(Integer projectId, String title, String key, Boolean canPush) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("key", key, true).withParam("can_push", canPush);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", projectId, "deploy_keys"});
        return (DeployKey)response.readEntity(DeployKey.class);
    }

    public void deleteDeployKey(Integer projectId, Integer keyId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        this.delete(Response.Status.OK, null, "projects", projectId, "deploy_keys", keyId);
    }

    public DeployKey enableDeployKey(Integer projectId, Integer keyId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        Response response = this.post(Response.Status.CREATED, (Form)null, new Object[]{"projects", projectId, "deploy_keys", keyId, "enable"});
        return (DeployKey)response.readEntity(DeployKey.class);
    }
}

