/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven.sbom;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.graalvm.buildtools.maven.sbom.ArtifactAdapter;
import org.graalvm.buildtools.maven.sbom.ArtifactAdapterResolver;
import org.graalvm.buildtools.maven.sbom.FileWalkerUtility;

final class ArtifactToPackageNameResolver {
    private final MavenProject mavenProject;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;
    private final ArtifactAdapterResolver shadedPackageNameResolver;

    ArtifactToPackageNameResolver(MavenProject mavenProject, RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, String mainClass) {
        this.mavenProject = mavenProject;
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = mavenProject.getRemoteProjectRepositories();
        this.shadedPackageNameResolver = new ArtifactAdapterResolver(mavenProject, mainClass);
    }

    Set<ArtifactAdapter> getArtifactAdapters() throws Exception {
        HashSet<ArtifactAdapter> artifactsWithPackageNameMappings = new HashSet<ArtifactAdapter>();
        ArrayList<org.apache.maven.artifact.Artifact> artifacts = new ArrayList<org.apache.maven.artifact.Artifact>(this.mavenProject.getArtifacts());
        artifacts.add(this.mavenProject.getArtifact());
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            Optional<ArtifactAdapter> optionalArtifact = this.resolvePackageNamesFromArtifact(artifact);
            if (optionalArtifact.isPresent()) {
                artifactsWithPackageNameMappings.add(optionalArtifact.get());
                continue;
            }
            ArtifactAdapter artifactAdapter = ArtifactAdapter.fromMavenArtifact(artifact);
            artifactAdapter.prunable = false;
            artifactsWithPackageNameMappings.add(artifactAdapter);
        }
        Set<ArtifactAdapter> dependencies = artifactsWithPackageNameMappings.stream().filter(v -> !v.equals(this.mavenProject.getArtifact())).collect(Collectors.toSet());
        ArtifactAdapterResolver.markShadedArtifactsAsNonPrunable(dependencies);
        return artifactsWithPackageNameMappings;
    }

    private Optional<ArtifactAdapter> resolvePackageNamesFromArtifact(org.apache.maven.artifact.Artifact artifact) throws ArtifactResolutionException, IOException {
        File artifactFile = artifact.getFile();
        if (artifactFile != null && artifactFile.exists()) {
            return this.resolvePackageNamesFromArtifactFile(artifactFile, ArtifactAdapter.fromMavenArtifact(artifact));
        }
        DefaultArtifact sourceArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "sources", "jar", artifact.getVersion());
        ArtifactRequest request = new ArtifactRequest().setArtifact((Artifact)sourceArtifact).setRepositories(this.remoteRepositories);
        ArtifactResult result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, request);
        if (result != null && result.getArtifact() != null && result.getArtifact().getFile() != null) {
            File sourceFile = result.getArtifact().getFile();
            return this.resolvePackageNamesFromArtifactFile(sourceFile, ArtifactAdapter.fromEclipseArtifact(result.getArtifact()));
        }
        return Optional.empty();
    }

    private Optional<ArtifactAdapter> resolvePackageNamesFromArtifactFile(File artifactFile, ArtifactAdapter artifact) throws IOException {
        if (!artifactFile.exists()) {
            return Optional.empty();
        }
        Path sourcePath = artifactFile.toPath();
        if (artifactFile.isDirectory()) {
            Set<String> packageNames = FileWalkerUtility.collectPackageNamesFromDirectory(artifactFile.toPath()).orElse(Set.of());
            artifact.setPackageNames(packageNames);
            return Optional.of(artifact);
        }
        if (artifactFile.getName().endsWith(".jar")) {
            return this.shadedPackageNameResolver.populateWithAdditionalFields(sourcePath, artifact);
        }
        return Optional.empty();
    }
}

