/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.graal.nodes.DeadEndNode;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.Phase;

public class OptimizeExceptionCallsPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        for (DeadEndNode deadEnd : graph.getNodes(DeadEndNode.TYPE)) {
            OptimizeExceptionCallsPhase.setBranchProbability((Node)deadEnd);
        }
    }

    private static void setBranchProbability(Node endNode) {
        Node node = endNode;
        Node predecessor = node.predecessor();
        while (predecessor != null) {
            if (predecessor instanceof IfNode && node instanceof BeginNode) {
                IfNode ifNode;
                ifNode.setTrueSuccessorProbability(node == (ifNode = (IfNode)predecessor).trueSuccessor() ? 1.0E-5 : 0.99999);
                return;
            }
            if (predecessor instanceof MergeNode || predecessor instanceof ControlSplitNode) {
                return;
            }
            node = predecessor;
            predecessor = node.predecessor();
        }
    }
}

