/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.CompilerCommandPlugin;
import com.oracle.svm.core.jdk.Target_java_lang_Shutdown;
import com.oracle.svm.core.util.VMError;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.VMRuntimeSupport;

public final class RuntimeSupport
implements VMRuntimeSupport {
    private AtomicReference<Runnable[]> startupHooks = new AtomicReference();
    private AtomicReference<Runnable[]> shutdownHooks = new AtomicReference();
    private AtomicReference<Runnable[]> tearDownHooks = new AtomicReference();
    private static final Comparator<CompilerCommandPlugin> PluginComparator = Comparator.comparing(CompilerCommandPlugin::name);
    private CopyOnWriteArrayList<CompilerCommandPlugin> commandPlugins = new CopyOnWriteArrayList();
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private boolean commandPluginsSorted = false;

    private RuntimeSupport() {
    }

    public static void initializeRuntimeSupport() {
        assert (!ImageSingletons.contains(RuntimeSupport.class)) : "Initializing RuntimeSupport again.";
        ImageSingletons.add(RuntimeSupport.class, (Object)new RuntimeSupport());
    }

    @Fold
    public static RuntimeSupport getRuntimeSupport() {
        return (RuntimeSupport)ImageSingletons.lookup(RuntimeSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addStartupHook(Runnable hook) {
        RuntimeSupport.addHook(this.startupHooks, hook);
    }

    public void executeStartupHooks() {
        RuntimeSupport.executeHooks(this.startupHooks);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addShutdownHook(Runnable hook) {
        RuntimeSupport.addHook(this.shutdownHooks, hook);
    }

    static void executeShutdownHooks() {
        RuntimeSupport.executeHooks(RuntimeSupport.getRuntimeSupport().shutdownHooks);
    }

    public void addTearDownHook(Runnable tearDownHook) {
        RuntimeSupport.addHook(this.tearDownHooks, tearDownHook);
    }

    public static void executeTearDownHooks() {
        RuntimeSupport.executeHooks(RuntimeSupport.getRuntimeSupport().tearDownHooks);
    }

    private static void addHook(AtomicReference<Runnable[]> hooksReference, Runnable newHook) {
        Runnable[] newHooks;
        Runnable[] existingHooks;
        Objects.requireNonNull(newHook);
        do {
            if ((existingHooks = hooksReference.get()) != null) {
                newHooks = Arrays.copyOf(existingHooks, existingHooks.length + 1);
                newHooks[newHooks.length - 1] = newHook;
                continue;
            }
            newHooks = new Runnable[]{newHook};
        } while (!hooksReference.compareAndSet(existingHooks, newHooks));
    }

    private static void executeHooks(AtomicReference<Runnable[]> hooksReference) {
        Runnable[] hooks = hooksReference.getAndSet(null);
        if (hooks != null) {
            for (Runnable hook : hooks) {
                hook.run();
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addCommandPlugin(CompilerCommandPlugin plugin) {
        assert (!this.commandPluginsSorted);
        if (this.commandPlugins.stream().anyMatch(p -> p.name().equals(plugin.name()))) {
            throw new IllegalArgumentException("CompilerCommandPlugin previously registered");
        }
        this.commandPlugins.add(plugin);
    }

    Object runCommand(final String cmd, Object[] args) {
        CompilerCommandPlugin key = new CompilerCommandPlugin(){

            @Override
            public String name() {
                return cmd;
            }

            @Override
            public Object apply(Object[] ignore) {
                throw VMError.shouldNotReachHere();
            }
        };
        int index = Collections.binarySearch(this.commandPlugins, key, PluginComparator);
        if (index >= 0) {
            return this.commandPlugins.get(index).apply(args);
        }
        throw new IllegalArgumentException("Could not find SVM command with the name " + cmd);
    }

    public void shutdown() {
        Target_java_lang_Shutdown.shutdown();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void sortCommandPlugins() {
        this.commandPlugins.sort(PluginComparator);
        assert (!this.commandPluginsSorted);
        this.commandPluginsSorted = true;
    }
}

