/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import java.io.FileInputStream;
import java.io.IOException;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={InternalPlatform.LINUX_JNI_AND_SUBSTITUTIONS.class})
class LinuxPhysicalMemory
extends PhysicalMemory {
    LinuxPhysicalMemory() {
    }

    @AutomaticFeature
    static class PhysicalMemoryFeature
    implements Feature {
        PhysicalMemoryFeature() {
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(PhysicalMemory.PhysicalMemorySupport.class, (Object)new PhysicalMemorySupportImpl());
        }
    }

    static class PhysicalMemorySupportImpl
    implements PhysicalMemory.PhysicalMemorySupport {
        static final long UNSET_SENTINEL = Long.MIN_VALUE;
        static UninterruptibleUtils.AtomicInteger initializeSize = new UninterruptibleUtils.AtomicInteger(0);
        long cachedSize = Long.MIN_VALUE;
        private static final String cgroupMemoryFileName = "/sys/fs/cgroup/memory/memory.limit_in_bytes";

        PhysicalMemorySupportImpl() {
        }

        @Override
        public UnsignedWord size() {
            if (this.hasSize()) {
                return this.getSize();
            }
            if (Heap.getHeap().isAllocationDisallowed() || VMOperation.isInProgress() || !JavaThreads.currentJavaThreadInitialized() || !initializeSize.compareAndSet(0, 1)) {
                return UnsignedUtils.MAX_VALUE;
            }
            this.initializeSize();
            initializeSize.set(0);
            return this.getSize();
        }

        @Override
        public boolean hasSize() {
            return this.cachedSize != Long.MIN_VALUE;
        }

        void setSize(long value) {
            this.cachedSize = value;
        }

        UnsignedWord getSize() {
            assert (this.hasSize()) : "LinuxPhysicalMemory.PhysicalMemorySupportImpl.geSize: cachedSize has no value.";
            return WordFactory.unsigned((long)this.cachedSize);
        }

        void initializeSize() {
            long cgroupSize = this.sizeFromCGroup();
            long sysconfSize = this.sizeFromSysconf();
            long minSize = Math.min(cgroupSize, sysconfSize);
            this.setSize(minSize);
        }

        long sizeFromSysconf() {
            long numberOfPhysicalMemoryPages = Unistd.sysconf(Unistd._SC_PHYS_PAGES());
            long sizeOfAPhysicalMemoryPage = Unistd.sysconf(Unistd._SC_PAGESIZE());
            long result = numberOfPhysicalMemoryPages * sizeOfAPhysicalMemoryPage;
            return result;
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="Only called if allocation is allowed.")
        long sizeFromCGroup() {
            assert (!Heap.getHeap().isAllocationDisallowed()) : "LinuxPhysicalMemory.PhysicalMemorySupportImpl.sizeFromCGroup: Allocation disallowed.";
            long result = Long.MAX_VALUE;
            try (FileInputStream stream = new FileInputStream(cgroupMemoryFileName);){
                StringBuilder sb = new StringBuilder(32);
                int read = stream.read();
                while (read >= 48 && read <= 57) {
                    sb.append((char)read);
                    read = stream.read();
                }
                result = Long.parseLong(sb.toString());
            }
            catch (IOException | NumberFormatException exception) {
                // empty catch block
            }
            return result;
        }
    }
}

