/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.pthread.PthreadConditionUtils;
import com.oracle.svm.core.posix.pthread.PthreadVMCondition;
import com.oracle.svm.core.posix.pthread.PthreadVMMutex;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.word.WordFactory;

public final class PthreadVMLockSupport {
    @UnknownObjectField(types={PthreadVMMutex[].class})
    protected PthreadVMMutex[] mutexes;
    @UnknownObjectField(types={PthreadVMCondition[].class})
    protected PthreadVMCondition[] conditions;
    @UnknownObjectField(types={byte[].class})
    protected byte[] pthreadStructs;

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static boolean initialize() {
        for (PthreadVMMutex mutex : ((PthreadVMLockSupport)ImageSingletons.lookup(PthreadVMLockSupport.class)).mutexes) {
            if (Pthread.pthread_mutex_init(mutex.getStructPointer(), (Pthread.pthread_mutexattr_t)WordFactory.nullPointer()) == 0) continue;
            return false;
        }
        for (PthreadVMCondition condition : ((PthreadVMLockSupport)ImageSingletons.lookup(PthreadVMLockSupport.class)).conditions) {
            if (PthreadConditionUtils.initCondition(condition.getStructPointer()) == 0) continue;
            return false;
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", calleeMustBe=false)
    protected static void checkResult(int result, String functionName) {
        if (result != 0) {
            VMThreads.StatusSupport.setStatusIgnoreSafepoints();
            Log.log().string(functionName).string(" returned ").signed(result).newline();
            ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
        }
    }
}

