/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.thread;

import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.pthread.PthreadConditionUtils;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

class PosixParkEvent
extends ParkEvent {
    private final Pthread.pthread_mutex_t mutex = (Pthread.pthread_mutex_t)LibC.malloc(SizeOf.unsigned(Pthread.pthread_mutex_t.class));
    private final Pthread.pthread_cond_t cond;

    PosixParkEvent() {
        VMError.guarantee(this.mutex.isNonNull(), "mutex allocation");
        Pthread.pthread_mutexattr_t mutexAttr = (Pthread.pthread_mutexattr_t)WordFactory.nullPointer();
        PosixUtils.checkStatusIs0(Pthread.pthread_mutex_init(this.mutex, mutexAttr), "mutex initialization");
        this.cond = (Pthread.pthread_cond_t)LibC.malloc(SizeOf.unsigned(Pthread.pthread_cond_t.class));
        VMError.guarantee(this.cond.isNonNull(), "condition variable allocation");
        PosixUtils.checkStatusIs0(PthreadConditionUtils.initCondition(this.cond), "condition variable initialization");
    }

    @Override
    protected ParkEvent.WaitResult condWait() {
        ParkEvent.WaitResult result = ParkEvent.WaitResult.UNPARKED;
        PosixUtils.checkStatusIs0(Pthread.pthread_mutex_lock(this.mutex), "park(): mutex lock");
        try {
            if (this.resetEventBeforeWait) {
                this.event = false;
            }
            while (!this.event) {
                if (Thread.interrupted()) {
                    ParkEvent.WaitResult waitResult = result = ParkEvent.WaitResult.INTERRUPTED;
                    return waitResult;
                }
                int status = Pthread.pthread_cond_wait(this.cond, this.mutex);
                if (status == Errno.EINTR() || status == Errno.ETIMEDOUT()) {
                    result = ParkEvent.WaitResult.INTERRUPTED;
                    break;
                }
                PosixUtils.checkStatusIs0(status, "park(): condition variable wait");
            }
            if (this.event) {
                this.event = false;
                result = ParkEvent.WaitResult.UNPARKED;
            }
        }
        finally {
            PosixUtils.checkStatusIs0(Pthread.pthread_mutex_unlock(this.mutex), "park(): mutex unlock");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ParkEvent.WaitResult condTimedWait(long delayNanos) {
        Time.timespec deadlineTimespec = (Time.timespec)StackValue.get(Time.timespec.class);
        PthreadConditionUtils.delayNanosToDeadlineTimespec(delayNanos, deadlineTimespec);
        ParkEvent.WaitResult result = ParkEvent.WaitResult.UNPARKED;
        PosixUtils.checkStatusIs0(Pthread.pthread_mutex_lock(this.mutex), "park(long): mutex lock");
        try {
            if (this.resetEventBeforeWait) {
                this.event = false;
            }
            while (!this.event) {
                if (Thread.interrupted()) {
                    ParkEvent.WaitResult waitResult = result = ParkEvent.WaitResult.INTERRUPTED;
                    return waitResult;
                }
                int status = Pthread.pthread_cond_timedwait(this.cond, this.mutex, deadlineTimespec);
                if (status == Errno.ETIMEDOUT()) {
                    result = ParkEvent.WaitResult.TIMED_OUT;
                    break;
                }
                if (status == Errno.EINTR()) {
                    result = ParkEvent.WaitResult.INTERRUPTED;
                    break;
                }
                if (status == 0) continue;
                Log.log().newline().string("[PosixParkEvent.condTimedWait(delayNanos: ").signed(delayNanos).string("): Should not reach here.").string("  mutex: ").hex((WordBase)this.mutex).string("  cond: ").hex((WordBase)this.cond).string("  deadlineTimeSpec.tv_sec: ").signed(deadlineTimespec.tv_sec()).string("  deadlineTimespec.tv_nsec: ").signed(deadlineTimespec.tv_nsec()).string("  status: ").signed(status).string(" ").string(Errno.strerror(status)).string("]").newline();
                PosixUtils.checkStatusIs0(status, "park(long): condition variable timed wait");
            }
            if (this.event) {
                this.event = false;
                result = ParkEvent.WaitResult.UNPARKED;
            }
        }
        finally {
            PosixUtils.checkStatusIs0(Pthread.pthread_mutex_unlock(this.mutex), "park(long): mutex unlock");
        }
        return result;
    }

    @Override
    protected void unpark() {
        PosixUtils.checkStatusIs0(Pthread.pthread_mutex_lock(this.mutex), "PosixParkEvent.unpark(): mutex lock");
        try {
            this.event = true;
            PosixUtils.checkStatusIs0(Pthread.pthread_cond_broadcast(this.cond), "PosixParkEvent.unpark(): condition variable broadcast");
        }
        finally {
            PosixUtils.checkStatusIs0(Pthread.pthread_mutex_unlock(this.mutex), "PosixParkEvent.unpark(): mutex unlock");
        }
    }
}

