/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.nodes.WriteHeapBaseNode;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

public abstract class SubstrateSegfaultHandler {
    static void startupHook() {
        Boolean optionValue = Options.InstallSegfaultHandler.getValue();
        if (optionValue == Boolean.TRUE || optionValue == null && ImageInfo.isExecutable()) {
            ((SubstrateSegfaultHandler)ImageSingletons.lookup(SubstrateSegfaultHandler.class)).install();
        }
    }

    protected abstract void install();

    @Uninterruptible(reason="Called from uninterruptible code.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault handler.", overridesCallers=true)
    protected static boolean tryEnterIsolate(RegisterDumper.Context context) {
        Isolate isolate;
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            PointerBase heapBase = RegisterDumper.singleton().getHeapBase(context);
            WriteHeapBaseNode.writeCurrentVMHeapBase(heapBase);
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            PointerBase threadPointer = RegisterDumper.singleton().getThreadPointer(context);
            WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)threadPointer);
        }
        return Isolates.checkSanity(isolate = VMThreads.IsolateTL.get()) == 0 && (SubstrateOptions.SpawnIsolates.getValue() == false || isolate.equal((ComparableWord)KnownIntrinsics.heapBase()));
    }

    @Uninterruptible(reason="Must be uninterruptible until we get immune to safepoints.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault handler.", overridesCallers=true)
    protected static void dump(RegisterDumper.Context context) {
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        SubstrateSegfaultHandler.dumpInterruptibly(context);
    }

    private static void dumpInterruptibly(RegisterDumper.Context context) {
        Log log = Log.log();
        log.autoflush(true);
        log.newline();
        log.string("[ [ SubstrateSegfaultHandler caught a segfault. ] ]").newline();
        PointerBase sp = RegisterDumper.singleton().getSP(context);
        PointerBase ip = RegisterDumper.singleton().getIP(context);
        SubstrateUtil.printDiagnostics(log, (Pointer)sp, (CodePointer)ip, context);
        log.string("Segfault detected, aborting process. Use runtime option -R:-InstallSegfaultHandler if you don't want to use SubstrateSegfaultHandler.").newline();
        log.newline();
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }

    public static class Options {
        @Option(help={"Install segfault handler that prints register contents and full Java stacktrace. Default: enabled for an executable, disabled for a shared library."})
        static final RuntimeOptionKey<Boolean> InstallSegfaultHandler = new RuntimeOptionKey<Object>(null);
    }
}

