/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.meta.SharedType;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.nodes.BasicObjectCloneNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;

@NodeInfo(allowedUsageTypes={InputType.Memory})
public final class SubstrateObjectCloneNode
extends BasicObjectCloneNode
implements DeoptimizingNode.DeoptBefore {
    public static final NodeClass<SubstrateObjectCloneNode> TYPE = NodeClass.create(SubstrateObjectCloneNode.class);
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;

    public SubstrateObjectCloneNode(MacroNode.MacroParams p) {
        super(TYPE, p);
    }

    public LoadFieldNode genLoadFieldNode(Assumptions assumptions, ValueNode originalAlias, ResolvedJavaField field) {
        if (field.getJavaKind() == JavaKind.Object && field.getType() instanceof SharedType) {
            TypeReference trusted = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)((SharedType)field.getType()));
            StampPair pair = StampPair.createSingle((Stamp)StampFactory.object((TypeReference)trusted, (boolean)false));
            return LoadFieldNode.createOverrideStamp((StampPair)pair, (ValueNode)originalAlias, (ResolvedJavaField)field);
        }
        return super.genLoadFieldNode(assumptions, originalAlias, field);
    }

    public void lower(LoweringTool tool) {
        tool.getLowerer().lower((Node)this, tool);
    }

    public boolean canDeoptimize() {
        return true;
    }

    public FrameState stateBefore() {
        return this.stateBefore;
    }

    public void setStateBefore(FrameState f) {
        this.updateUsages((Node)this.stateBefore, (Node)f);
        this.stateBefore = f;
    }
}

