/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;

final class ReferenceHandlerRunnable
implements Runnable {
    ReferenceHandlerRunnable() {
    }

    @Override
    public void run() {
        ThreadingSupportImpl.pauseRecurringCallback("An exception in a recurring callback must not interrupt pending reference processing because it could result in a memory leak.");
        try {
            while (true) {
                ReferenceInternals.waitForPendingReferences();
                ReferenceInternals.processPendingReferences();
                ReferenceHandler.processCleaners();
            }
        }
        catch (InterruptedException e) {
            VMError.guarantee(VMThreads.isTearingDown(), "Reference Handler should only be interrupted during tear-down");
            ThreadingSupportImpl.resumeRecurringCallback();
        }
        catch (Throwable t) {
            try {
                VMError.shouldNotReachHere("Reference processing and cleaners must handle all potential exceptions", t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ThreadingSupportImpl.resumeRecurringCallback();
            }
        }
    }
}

