/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.NumUtil;

public class SubstrateReferenceMap
extends ReferenceMap
implements ReferenceMapEncoder.Input {
    private BitSet shiftedOffsets;
    private int shift;
    private EconomicMap<Integer, Set<Integer>> derived;
    private Map<Integer, Object> debugAllUsedRegisters;
    private Map<Integer, Object> debugAllUsedStackSlots;

    public SubstrateReferenceMap() {
        assert (ConfigurationValues.getObjectLayout().getReferenceSize() > 2) : "needs to be three bits or more for encoding and validation";
    }

    public boolean isOffsetMarked(int offset) {
        return this.shiftedOffsets != null && offset + this.shift >= 0 && this.shiftedOffsets.get(offset + this.shift);
    }

    public void markReferenceAtOffset(int offset, boolean compressed) {
        if (this.shiftedOffsets == null) {
            this.shiftedOffsets = new BitSet();
        }
        if (offset < -this.shift) {
            int newShift = NumUtil.roundUp((int)(-offset), (int)64);
            int shiftDelta = newShift - this.shift;
            assert (shiftDelta > 0 && NumUtil.roundUp((int)shiftDelta, (int)64) == shiftDelta);
            long[] oldData = this.shiftedOffsets.toLongArray();
            long[] newData = new long[oldData.length + shiftDelta / 64];
            System.arraycopy(oldData, 0, newData, shiftDelta / 64, oldData.length);
            this.shiftedOffsets = BitSet.valueOf(newData);
            this.shift = newShift;
        }
        assert (this.isValidToMark(offset, compressed)) : "already marked or would overlap with predecessor or successor";
        this.shiftedOffsets.set(offset + this.shift);
        if (compressed) {
            this.shiftedOffsets.set(offset + 1 + this.shift);
        }
    }

    public void markReferenceAtOffset(int offset, int baseOffset, boolean compressed) {
        HashSet<Integer> derivedOffsets;
        if (offset == baseOffset) {
            if (this.derived == null || !this.derived.containsKey((Object)baseOffset)) {
                this.markReferenceAtOffset(baseOffset, compressed);
            }
            return;
        }
        if (!this.isOffsetMarked(baseOffset)) {
            this.markReferenceAtOffset(baseOffset, compressed);
        }
        if (this.derived == null) {
            this.derived = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        }
        if ((derivedOffsets = (HashSet<Integer>)this.derived.get((Object)baseOffset)) == null) {
            derivedOffsets = new HashSet<Integer>();
            this.derived.put((Object)baseOffset, derivedOffsets);
        }
        assert (!derivedOffsets.contains(offset));
        derivedOffsets.add(offset);
    }

    private boolean isValidToMark(int offset, boolean isCompressed) {
        int uncompressedSize = FrameAccess.uncompressedReferenceSize();
        int compressedSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        int previousShiftedOffset = this.shiftedOffsets.previousSetBit(offset - 1 + this.shift);
        if (previousShiftedOffset != -1) {
            int minShiftedOffset = previousShiftedOffset + uncompressedSize;
            if (previousShiftedOffset != 0 && this.shiftedOffsets.get(previousShiftedOffset - 1)) {
                minShiftedOffset = --previousShiftedOffset + compressedSize;
            }
            if (offset + this.shift < minShiftedOffset) {
                return false;
            }
        }
        int size = isCompressed ? compressedSize : uncompressedSize;
        int nextShiftedOffset = this.shiftedOffsets.nextSetBit(offset + this.shift);
        return nextShiftedOffset == -1 || offset + this.shift + size <= nextShiftedOffset;
    }

    public Map<Integer, Object> getDebugAllUsedRegisters() {
        return this.debugAllUsedRegisters;
    }

    boolean debugMarkRegister(int offset, Value value) {
        if (this.debugAllUsedRegisters == null) {
            this.debugAllUsedRegisters = new HashMap<Integer, Object>();
        }
        this.debugAllUsedRegisters.put(offset, value);
        return true;
    }

    public Map<Integer, Object> getDebugAllUsedStackSlots() {
        return this.debugAllUsedStackSlots;
    }

    boolean debugMarkStackSlot(int offset, StackSlot value) {
        if (this.debugAllUsedStackSlots == null) {
            this.debugAllUsedStackSlots = new HashMap<Integer, Object>();
        }
        this.debugAllUsedStackSlots.put(offset, value);
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.shiftedOffsets == null || this.shiftedOffsets.isEmpty();
    }

    @Override
    public ReferenceMapEncoder.OffsetIterator getOffsets() {
        return new ReferenceMapEncoder.OffsetIterator(){
            private int nextShiftedOffset;
            {
                this.nextShiftedOffset = SubstrateReferenceMap.this.shiftedOffsets == null ? -1 : SubstrateReferenceMap.this.shiftedOffsets.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.nextShiftedOffset != -1;
            }

            @Override
            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int result = this.nextShiftedOffset - SubstrateReferenceMap.this.shift;
                this.nextShiftedOffset = SubstrateReferenceMap.this.shiftedOffsets.nextSetBit(this.nextShiftedOffset + 2);
                return result;
            }

            @Override
            public boolean isNextCompressed() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SubstrateReferenceMap.this.shiftedOffsets.get(this.nextShiftedOffset + 1);
            }

            @Override
            public boolean isNextDerived() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SubstrateReferenceMap.this.derived != null && SubstrateReferenceMap.this.derived.containsKey((Object)(this.nextShiftedOffset - SubstrateReferenceMap.this.shift));
            }

            @Override
            public Set<Integer> getDerivedOffsets(int baseOffset) {
                if (SubstrateReferenceMap.this.derived == null || !SubstrateReferenceMap.this.derived.containsKey((Object)baseOffset)) {
                    throw new NoSuchElementException();
                }
                return (Set)SubstrateReferenceMap.this.derived.get((Object)baseOffset);
            }
        };
    }

    public int hashCode() {
        return this.shift ^ (this.shiftedOffsets == null ? 0 : this.shiftedOffsets.hashCode()) ^ (this.derived == null ? 0 : this.derived.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SubstrateReferenceMap) {
            SubstrateReferenceMap other = (SubstrateReferenceMap)obj;
            if (this.shift != other.shift || !Objects.equals(this.shiftedOffsets, other.shiftedOffsets)) {
                return false;
            }
            if (this.derived == null || other.derived == null) {
                return this.derived == null && other.derived == null;
            }
            if (this.derived.size() != other.derived.size()) {
                return false;
            }
            Iterator iterator = this.derived.getKeys().iterator();
            while (iterator.hasNext()) {
                int base = (Integer)iterator.next();
                if (((Set)this.derived.get((Object)base)).equals(other.derived.get((Object)base))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasNoDerivedOffsets() {
        return this.derived == null || this.derived.isEmpty();
    }

    public void verify() {
        if (this.derived == null) {
            return;
        }
        Iterator iterator = this.derived.getKeys().iterator();
        while (iterator.hasNext()) {
            int baseOffset = (Integer)iterator.next();
            Iterator iterator2 = ((Set)this.derived.get((Object)baseOffset)).iterator();
            while (iterator2.hasNext()) {
                int derivedOffset = (Integer)iterator2.next();
                assert (!this.derived.containsKey((Object)derivedOffset));
            }
        }
    }

    public StringBuilder dump(StringBuilder builder) {
        if (this.shiftedOffsets == null || this.shiftedOffsets.isEmpty()) {
            builder.append("[]");
            return builder;
        }
        builder.append('[');
        this.shiftedOffsets.stream().forEach(shiftedOffset -> {
            int offset = shiftedOffset - this.shift;
            builder.append(offset);
            if (this.derived != null && this.derived.containsKey((Object)offset)) {
                builder.append(" -> {");
                Iterator iterator = ((Set)this.derived.get((Object)offset)).iterator();
                while (iterator.hasNext()) {
                    int derivedOffset = (Integer)iterator.next();
                    builder.append(derivedOffset);
                    builder.append(", ");
                }
                builder.replace(builder.length() - 2, builder.length(), "}");
            }
            builder.append(", ");
        });
        builder.replace(builder.length() - 2, builder.length(), "]");
        return builder;
    }

    public String toString() {
        return this.dump(new StringBuilder()).toString();
    }
}

