/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import java.lang.reflect.AnnotatedElement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.util.GuardedAnnotationAccess;

public class ClassLoaderSupport {
    private static final ConcurrentMap<ClassLoader, ConcurrentHashMap<String, Package>> registeredPackages = new ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, Package>>();

    public static void registerPackage(ClassLoader classLoader, String packageName, Package packageValue) {
        assert (classLoader != null);
        assert (packageName != null);
        assert (packageValue != null);
        GuardedAnnotationAccess.getAnnotations((AnnotatedElement)packageValue);
        ConcurrentMap classPackages = registeredPackages.computeIfAbsent(classLoader, k -> new ConcurrentHashMap());
        classPackages.putIfAbsent(packageName, packageValue);
    }

    public static ConcurrentHashMap<String, Package> getRegisteredPackages(ClassLoader classLoader) {
        return (ConcurrentHashMap)registeredPackages.get(classLoader);
    }
}

