/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.proxy;

import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.jdk.proxy.Target_java_lang_reflect_WeakCache;
import com.oracle.svm.core.jdk.proxy.Target_jdk_internal_loader_ClassLoaderValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=Proxy.class)
final class Target_java_lang_reflect_Proxy {
    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static Target_java_lang_reflect_WeakCache proxyClassCache;
    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static Target_jdk_internal_loader_ClassLoaderValue proxyCache;

    Target_java_lang_reflect_Proxy() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static Class<?> getProxyClass0(ClassLoader loader, Class<?> ... interfaces) {
        return ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).getProxyClass(interfaces);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static Constructor<?> getProxyConstructor(Class<?> caller, ClassLoader loader, Class<?> ... interfaces) {
        Class<?> cl = ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).getProxyClass(interfaces);
        try {
            Constructor<?> cons = cl.getConstructor(InvocationHandler.class);
            if (!Modifier.isPublic(cl.getModifiers())) {
                cons.setAccessible(true);
            }
            return cons;
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString(), e);
        }
    }

    @Substitute
    public static boolean isProxyClass(Class<?> cl) {
        return Proxy.class.isAssignableFrom(cl) && ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).isProxyClass(cl);
    }

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native Class<?> defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);
}

