/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.hosted.config.HybridLayoutSupport;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageSingletons;

public class HybridLayout<T> {
    private final ObjectLayout layout;
    private final HostedField arrayField;
    private final HostedField typeIDSlotsField;
    private final int instanceSize;

    public static boolean isHybrid(ResolvedJavaType clazz) {
        return ((HybridLayoutSupport)ImageSingletons.lookup(HybridLayoutSupport.class)).isHybrid(clazz);
    }

    public static boolean isHybridField(ResolvedJavaField field) {
        return ((HybridLayoutSupport)ImageSingletons.lookup(HybridLayoutSupport.class)).isHybridField(field);
    }

    public HybridLayout(Class<T> hybridClass, ObjectLayout layout, HostedMetaAccess metaAccess) {
        this((HostedInstanceClass)metaAccess.lookupJavaType((Class)hybridClass), layout);
    }

    public HybridLayout(HostedInstanceClass hybridClass, ObjectLayout layout) {
        this.layout = layout;
        HybridLayoutSupport utils = (HybridLayoutSupport)ImageSingletons.lookup(HybridLayoutSupport.class);
        HybridLayoutSupport.HybridFields hybridFields = utils.findHybridFields(hybridClass);
        this.arrayField = hybridFields.arrayField;
        this.typeIDSlotsField = hybridFields.typeIDSlotsField;
        this.instanceSize = hybridClass.getInstanceSize();
    }

    public JavaKind getArrayElementStorageKind() {
        return this.arrayField.getType().getComponentType().getStorageKind();
    }

    public int getArrayBaseOffset() {
        return NumUtil.roundUp((int)this.instanceSize, (int)this.layout.sizeInBytes(this.getArrayElementStorageKind()));
    }

    public long getArrayElementOffset(int index) {
        return this.getArrayBaseOffset() + index * this.layout.sizeInBytes(this.getArrayElementStorageKind());
    }

    public long getTotalSize(int length) {
        return this.layout.alignUp(this.getArrayElementOffset(length));
    }

    public HostedField getArrayField() {
        return this.arrayField;
    }

    public HostedField getTypeIDSlotsField() {
        return this.typeIDSlotsField;
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public static int getTypeIDSlotsFieldOffset(ObjectLayout layout) {
        return layout.getArrayLengthOffset() + layout.sizeInBytes(JavaKind.Int);
    }
}

