/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class ToJson {
    private static final String EMPTY = "";
    private static final String NEW_LINE = "\n";
    private static final char TAB = '\t';
    private static final String OPEN_OBJECT = "{";
    private static final String CLOSE_OBJECT = "}";
    private static final String OPEN_ARRAY = "[";
    private static final String CLOSE_ARRAY = "]";
    private static final char QUOTE = '\"';
    private static final char SLASH = '\\';
    private static final BitSet ESC = Arrays.asList(Character.valueOf('\\'), Character.valueOf('\"'), Character.valueOf('\b'), Character.valueOf('\f'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t'), Character.valueOf('/')).stream().collect(BitSet::new, BitSet::set, BitSet::or);
    private static final Map<Character, Character> MAP = new HashMap<Character, Character>();
    private final boolean pretty;
    private final String newPrefix;
    private final String prefi;
    private final String colon;
    private int depth = 0;
    private String pref;
    private final List<String> prepends = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;

        @Override
        public String get(int index) {
            while (this.size() <= index) {
                this.add(this.getFill(this.size()));
            }
            return (String)super.get(index);
        }

        private String getFill(int size) {
            return size == 0 ? ToJson.EMPTY : (String)super.get(size - 1) + '\t';
        }
    };

    public ToJson() {
        this(false);
    }

    public ToJson(boolean pretty) {
        this.pretty = pretty;
        if (pretty) {
            this.prefi = ",\n";
            this.newPrefix = NEW_LINE;
            this.colon = ": ";
        } else {
            this.prefi = ",";
            this.newPrefix = EMPTY;
            this.colon = ":";
        }
        this.pref = this.newPrefix;
    }

    public void printHeader(PrintWriter writer) {
        writer.append(OPEN_OBJECT);
        ++this.depth;
    }

    private void prepend(PrintWriter writer) {
        if (this.pretty) {
            writer.append(this.prepends.get(this.depth));
        }
    }

    public void put(PrintWriter writer, String name, JsonValue value) {
        if (this.depth == 0) {
            this.printHeader(writer);
        }
        if (value != null) {
            writer.print(this.pref);
            this.putProperty(writer, name, value);
            this.pref = this.prefi;
        }
    }

    private void putProperty(PrintWriter writer, String name, JsonValue value) {
        this.prepend(writer);
        ToJson.dumpString(writer, name);
        writer.append(this.colon);
        value.dump(writer, this);
    }

    private static void dumpString(PrintWriter writer, String string) {
        writer.append('\"');
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (ESC.get(c)) {
                writer.append('\\');
                writer.append(MAP.getOrDefault(Character.valueOf(c), Character.valueOf(c)).charValue());
                continue;
            }
            writer.append(c);
        }
        writer.append('\"');
    }

    private static void dumpElement(PrintWriter writer, String element) {
        writer.print(element);
    }

    private static void dumpNumber(PrintWriter writer, Number number) {
        writer.print(number);
    }

    private void dumpArray(PrintWriter writer, Stream<JsonValue> values) {
        writer.append(OPEN_ARRAY);
        ++this.depth;
        String[] prefix = new String[]{this.newPrefix};
        ((Stream)values.sequential()).forEach(val -> {
            if (val != null) {
                writer.print(prefix[0]);
                this.prepend(writer);
                val.dump(writer, this);
                prefix[0] = this.prefi;
            }
        });
        --this.depth;
        if (this.pretty && !prefix[0].equals(NEW_LINE)) {
            writer.append(NEW_LINE);
            this.prepend(writer);
        }
        writer.append(CLOSE_ARRAY);
    }

    private void dumpObject(PrintWriter writer, Stream<String> names, Function<String, JsonValue> func) {
        writer.append(OPEN_OBJECT);
        ++this.depth;
        String[] prefix = new String[]{this.newPrefix};
        ((Stream)names.sequential()).forEach(name -> {
            JsonValue val = (JsonValue)func.apply((String)name);
            if (val != null) {
                writer.print(prefix[0]);
                this.putProperty(writer, (String)name, val);
                prefix[0] = this.prefi;
            }
        });
        --this.depth;
        if (this.pretty && !prefix[0].equals(NEW_LINE)) {
            writer.append(NEW_LINE);
            this.prepend(writer);
        }
        writer.append(CLOSE_OBJECT);
    }

    public void close(PrintWriter writer) {
        --this.depth;
        assert (this.depth == 0);
        writer.append(CLOSE_OBJECT);
    }

    static {
        MAP.put(Character.valueOf('\b'), Character.valueOf('b'));
        MAP.put(Character.valueOf('\f'), Character.valueOf('f'));
        MAP.put(Character.valueOf('\n'), Character.valueOf('n'));
        MAP.put(Character.valueOf('\r'), Character.valueOf('r'));
        MAP.put(Character.valueOf('\t'), Character.valueOf('t'));
    }

    public static abstract class JsonObject
    extends JsonValue {
        public static JsonObject get(final Stream<String> names, final Function<String, JsonValue> func) {
            return names == null || func == null ? null : new JsonObject(){

                @Override
                Stream<String> getNames() {
                    return names;
                }

                @Override
                JsonValue getValue(String name) {
                    return (JsonValue)func.apply(name);
                }
            };
        }

        abstract Stream<String> getNames();

        abstract JsonValue getValue(String var1);

        @Override
        final void dump(PrintWriter writer, ToJson access) {
            this.build();
            Stream<String> names = this.getNames();
            if (names == null) {
                JsonValue.NULL.dump(writer, access);
            } else {
                access.dumpObject(writer, names, this::getValue);
            }
        }
    }

    public static abstract class JsonArray
    extends JsonValue {
        public static JsonArray get(final Stream<JsonValue> values) {
            return values == null ? null : new JsonArray(){

                @Override
                Stream<JsonValue> getValues() {
                    return values;
                }
            };
        }

        abstract Stream<JsonValue> getValues();

        @Override
        final void dump(PrintWriter writer, ToJson access) {
            this.build();
            Stream<JsonValue> values = this.getValues();
            if (values == null) {
                JsonValue.NULL.dump(writer, access);
            } else {
                access.dumpArray(writer, values);
            }
        }
    }

    public static abstract class JsonString
    extends JsonValue {
        public static JsonString get(final String string) {
            return string == null ? null : new JsonString(){

                @Override
                String getString() {
                    return string;
                }
            };
        }

        abstract String getString();

        @Override
        final void dump(PrintWriter writer, ToJson access) {
            this.build();
            String string = this.getString();
            if (string == null) {
                JsonValue.NULL.dump(writer, access);
            } else {
                ToJson.dumpString(writer, string);
            }
        }
    }

    public static abstract class JsonNumber
    extends JsonValue {
        public static JsonNumber get(final Number number) {
            return number == null ? null : new JsonNumber(){

                @Override
                Number getNumber() {
                    return number;
                }
            };
        }

        abstract Number getNumber();

        @Override
        final void dump(PrintWriter writer, ToJson access) {
            this.build();
            Number number = this.getNumber();
            if (number == null) {
                JsonValue.NULL.dump(writer, access);
            } else {
                ToJson.dumpNumber(writer, number);
            }
        }
    }

    private static abstract class JsonElement
    extends JsonValue {
        private JsonElement() {
        }

        static JsonElement get(final String element) {
            return new JsonElement(){

                @Override
                String getElement() {
                    return element;
                }
            };
        }

        abstract String getElement();

        @Override
        final void dump(PrintWriter writer, ToJson access) {
            ToJson.dumpElement(writer, this.getElement());
        }
    }

    public static abstract class JsonValue {
        public static final JsonValue NULL = JsonElement.get("null");
        public static final JsonValue TRUE = JsonElement.get("true");
        public static final JsonValue FALSE = JsonElement.get("false");

        abstract void dump(PrintWriter var1, ToJson var2);

        protected void build() {
        }
    }
}

