/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.DeoptProxyAnchorNode;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.hosted.phases.SubstrateGraphBuilderPhase;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.KillingBeginNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;

class HostedBytecodeParser
extends SubstrateGraphBuilderPhase.SubstrateBytecodeParser {
    private static final DeoptEntryNode STICKY_DEOPT_ENTRY = new DeoptEntryNode();
    private int currentDeoptIndex;
    private Map<Long, DeoptProxyAnchorNode> deoptEntries = new HashMap<Long, DeoptProxyAnchorNode>();

    HostedBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
        super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, true);
    }

    public HostedMethod getMethod() {
        return (HostedMethod)super.getMethod();
    }

    protected boolean forceLoopPhis() {
        return this.getMethod().compilationInfo.isDeoptTarget() || super.forceLoopPhis();
    }

    protected boolean stampFromValueForForcedPhis() {
        return true;
    }

    protected void build(FixedWithNextNode startInstruction, FrameStateBuilder startFrameState) {
        super.build(startInstruction, startFrameState);
        this.getGraph().setGuardsStage(StructuredGraph.GuardsStage.FIXED_DEOPTS);
        assert (!this.getMethod().isEntryPoint()) : "Cannot directly use as entry point, create a call stub";
        if (this.getMethod().compilationInfo.isDeoptTarget()) {
            for (DeoptProxyNode deoptProxy : this.graph.getNodes(DeoptProxyNode.TYPE)) {
                if (deoptProxy.hasProxyPoint()) continue;
                ValueNode originalValue = deoptProxy.getOriginalNode();
                deoptProxy.replaceAtUsagesAndDelete((Node)originalValue);
            }
        }
    }

    @Override
    public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, JavaTypeProfile profile) {
        return new SubstrateMethodCallTargetNode(invokeKind, targetMethod, args, returnStamp, this.getMethod().getProfilingInfo(), this.bci());
    }

    private void insertProxies(FixedNode deoptTarget, FrameStateBuilder state) {
        state.insertProxies(value -> this.createProxyNode((ValueNode)value, deoptTarget));
        ++this.currentDeoptIndex;
    }

    private ValueNode createProxyNode(ValueNode value, FixedNode deoptTarget) {
        ValueNode v = DeoptProxyNode.create(value, (ValueNode)deoptTarget, this.currentDeoptIndex);
        if (v.graph() != null) {
            return v;
        }
        return (ValueNode)this.graph.addOrUniqueWithInputs((Node)v);
    }

    protected void finishPrepare(FixedWithNextNode startInstr, int bci, FrameStateBuilder state) {
        super.finishPrepare(startInstr, bci, state);
        if (this.getMethod().compilationInfo.isDeoptEntry(bci, false, false)) {
            DeoptEntryNode deoptEntry = (DeoptEntryNode)this.append((ValueNode)new DeoptEntryNode());
            deoptEntry.setStateAfter(this.frameState.create(bci, (StateSplit)deoptEntry));
            this.deoptEntries.put(Long.valueOf(bci), deoptEntry);
            this.insertProxies((FixedNode)deoptEntry, state);
        }
    }

    protected void parseAndInlineCallee(ResolvedJavaMethod targetMethod, ValueNode[] args, IntrinsicContext calleeIntrinsicContext) {
        if (this.getMethod().compilationInfo.isDeoptEntry(this.bci(), false, false)) {
            assert (NativeImageGenerator.nativeImageInlineDuringParsingEnabled() || calleeIntrinsicContext != null) : "only inlining replacements when inline during parsing disabled";
            FrameState stateAfter = this.frameState.create(this.bci(), this.getNonIntrinsicAncestor(), false, targetMethod.getSignature().toParameterKinds(!targetMethod.isStatic()), args);
            long encodedBci = FrameInfoEncoder.encodeBci(stateAfter.bci, stateAfter.duringCall(), stateAfter.rethrowException());
            if (!this.deoptEntries.containsKey(encodedBci)) {
                DeoptEntryNode deoptEntry = (DeoptEntryNode)this.graph.add((Node)new DeoptEntryNode());
                deoptEntry.setStateAfter(stateAfter);
                this.insertProxies((FixedNode)deoptEntry, this.frameState);
                this.lastInstr.setNext((FixedNode)deoptEntry);
                this.lastInstr = deoptEntry;
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this.createProxyNode(args[i], (FixedNode)deoptEntry);
                }
            }
            this.deoptEntries.put(encodedBci, STICKY_DEOPT_ENTRY);
        }
        super.parseAndInlineCallee(targetMethod, args, calleeIntrinsicContext);
    }

    protected FixedWithNextNode finishInstruction(FixedWithNextNode instr, FrameStateBuilder stateBuilder) {
        if (this.getMethod().compilationInfo.isDeoptTarget() && !this.parsingIntrinsic()) {
            long encodedBci;
            DeoptProxyAnchorNode existingDeoptEntry;
            FrameState stateAfter = null;
            if (instr instanceof StateSplit && !(instr instanceof DeoptEntryNode)) {
                StateSplit stateSplit = (StateSplit)instr;
                stateAfter = stateSplit.stateAfter();
            } else if (instr instanceof AbstractBeginNode) {
                Node predecessor = instr.predecessor();
                if (predecessor instanceof KillingBeginNode) {
                    predecessor = predecessor.predecessor();
                }
                if (predecessor instanceof StateSplit && !(predecessor instanceof DeoptEntryNode)) {
                    stateAfter = ((StateSplit)predecessor).stateAfter();
                }
            }
            boolean needsDeoptEntry = false;
            boolean needsProxies = false;
            if (stateAfter != null) {
                if (this.getMethod().compilationInfo.isDeoptEntry(stateAfter.bci, stateAfter.duringCall(), stateAfter.rethrowException())) {
                    needsDeoptEntry = true;
                    needsProxies = true;
                } else if (instr.predecessor() instanceof Invoke && this.getMethod().compilationInfo.isDeoptEntry(((Invoke)instr.predecessor()).bci(), true, false)) {
                    needsProxies = true;
                } else if (instr instanceof ExceptionObjectNode && this.getMethod().compilationInfo.isDeoptEntry(((ExceptionObjectNode)instr).stateAfter().bci, true, false)) {
                    needsProxies = true;
                }
            }
            if (needsProxies && ((existingDeoptEntry = this.deoptEntries.get(encodedBci = FrameInfoEncoder.encodeBci(stateAfter.bci, stateAfter.duringCall(), stateAfter.rethrowException()))) == null || existingDeoptEntry != STICKY_DEOPT_ENTRY && instr instanceof AbstractMergeNode)) {
                if (existingDeoptEntry != null) {
                    existingDeoptEntry.replaceAtUsages(null);
                    this.graph.removeFixed((FixedWithNextNode)existingDeoptEntry);
                    this.deoptEntries.remove(encodedBci);
                    if (existingDeoptEntry instanceof DeoptEntryNode) {
                        needsDeoptEntry = true;
                    }
                }
                assert (!this.deoptEntries.containsKey(encodedBci)) : "duplicate deopt entry for encoded BCI " + encodedBci;
                DeoptProxyAnchorNode deoptEntry = this.createDeoptEntry(stateBuilder, stateAfter, !needsDeoptEntry);
                if (instr instanceof LoopBeginNode) {
                    this.deoptEntries.put(encodedBci, STICKY_DEOPT_ENTRY);
                } else {
                    this.deoptEntries.put(encodedBci, deoptEntry);
                }
                assert (instr.next() == null) : "cannot append instruction to instruction which isn't end (" + instr + "->" + instr.next() + ")";
                instr.setNext((FixedNode)deoptEntry);
                return deoptEntry;
            }
        }
        return super.finishInstruction(instr, stateBuilder);
    }

    private DeoptProxyAnchorNode createDeoptEntry(FrameStateBuilder stateBuilder, FrameState stateAfter, boolean anchorOnly) {
        DeoptProxyAnchorNode deoptEntry = (DeoptProxyAnchorNode)this.graph.add((Node)(anchorOnly ? new DeoptProxyAnchorNode() : new DeoptEntryNode()));
        deoptEntry.setStateAfter(stateAfter);
        this.insertProxies((FixedNode)deoptEntry, stateBuilder);
        return deoptEntry;
    }
}

