/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.spring.provider.NullValue;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class SpringCache
implements Cache {
    private final BasicCache nativeCache;
    private final long readTimeout;
    private final long writeTimeout;
    private final Map<Object, ReentrantLock> synchronousGetLocks = new ConcurrentHashMap<Object, ReentrantLock>();

    public SpringCache(BasicCache nativeCache) {
        this(nativeCache, 0L, 0L);
    }

    public SpringCache(BasicCache nativeCache, long readTimeout, long writeTimeout) {
        Assert.notNull((Object)nativeCache, (String)"A non-null Infinispan cache implementation is required");
        this.nativeCache = nativeCache;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
    }

    public String getName() {
        return this.nativeCache.getName();
    }

    public BasicCache<?, ?> getNativeCache() {
        return this.nativeCache;
    }

    public Cache.ValueWrapper get(Object key) {
        try {
            if (this.readTimeout > 0L) {
                return this.wrap(this.nativeCache.getAsync(key).get(this.readTimeout, TimeUnit.MILLISECONDS));
            }
            return this.wrap(this.nativeCache.get(key));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public <T> T get(Object key, Class<T> type) {
        try {
            Object value = this.readTimeout > 0L ? this.nativeCache.getAsync(key).get(this.readTimeout, TimeUnit.MILLISECONDS) : this.nativeCache.get(key);
            value = this.unwrapNull(value);
            if (value != null && type != null && !type.isInstance(value)) {
                throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
            }
            return (T)value;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value;
        block7: {
            ReentrantLock lock = null;
            value = this.nativeCache.get(key);
            if (value == null) {
                lock = this.synchronousGetLocks.computeIfAbsent(key, k -> new ReentrantLock());
                lock.lock();
                try {
                    value = this.nativeCache.get(key);
                    if (value != null) break block7;
                    try {
                        T newValue = valueLoader.call();
                        value = this.nativeCache.putIfAbsent(key, (Object)(newValue == null ? NullValue.NULL : newValue));
                        if (value == null) {
                            value = newValue;
                        }
                    }
                    catch (Exception e) {
                        throw ValueRetrievalExceptionResolver.throwValueRetrievalException(key, valueLoader, e);
                    }
                }
                finally {
                    lock.unlock();
                    this.synchronousGetLocks.remove(key);
                }
            }
        }
        return this.unwrapNull(value);
    }

    public void put(Object key, Object value) {
        try {
            if (this.writeTimeout > 0L) {
                this.nativeCache.putAsync(key, value != null ? value : NullValue.NULL).get(this.writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.nativeCache.put(key, value != null ? value : NullValue.NULL);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void put(Object key, Object value, long lifespan, TimeUnit unit) {
        try {
            if (this.writeTimeout > 0L) {
                this.nativeCache.putAsync(key, value != null ? value : NullValue.NULL, lifespan, unit).get(this.writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.nativeCache.put(key, value != null ? value : NullValue.NULL, lifespan, unit);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        try {
            if (this.writeTimeout > 0L) {
                return this.wrap(this.nativeCache.putIfAbsentAsync(key, value).get(this.writeTimeout, TimeUnit.MILLISECONDS));
            }
            return this.wrap(this.nativeCache.putIfAbsent(key, value));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void evict(Object key) {
        try {
            if (this.writeTimeout > 0L) {
                this.nativeCache.removeAsync(key).get(this.writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.nativeCache.remove(key);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void clear() {
        try {
            if (this.writeTimeout > 0L) {
                this.nativeCache.clearAsync().get(this.writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.nativeCache.clear();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public String toString() {
        return "InfinispanCache [nativeCache = " + this.nativeCache + "]";
    }

    private Cache.ValueWrapper wrap(Object value) {
        if (value == null) {
            return null;
        }
        if (value == NullValue.NULL) {
            return NullValue.NULL;
        }
        return new SimpleValueWrapper(value);
    }

    private <T> T unwrapNull(Object value) {
        if (value == NullValue.NULL) {
            return null;
        }
        return (T)value;
    }

    private static class ValueRetrievalExceptionResolver {
        private ValueRetrievalExceptionResolver() {
        }

        static RuntimeException throwValueRetrievalException(Object key, Callable<?> loader, Throwable ex) {
            return new Cache.ValueRetrievalException(key, loader, ex);
        }
    }
}

