/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.generic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.springframework.core.io.Resource;

public class FileAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_SEPARATOR = "::";
    @NotNull
    private String separator = "::";
    @NotNull
    private Resource fileName;

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        try {
            String username = credential.getUsername();
            String passwordOnRecord = this.getPasswordOnRecord(username);
            if (StringUtils.isBlank((CharSequence)passwordOnRecord)) {
                throw new AccountNotFoundException(username + " not found in backing file.");
            }
            String password = credential.getPassword();
            if (StringUtils.isNotBlank((CharSequence)password) && this.getPasswordEncoder().encode(password).equals(passwordOnRecord)) {
                return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
            }
        }
        catch (IOException e) {
            throw new PreventedException("IO error reading backing file", (Throwable)e);
        }
        throw new FailedLoginException();
    }

    public final void setFileName(Resource fileName) {
        this.fileName = fileName;
    }

    public final void setSeparator(String separator) {
        this.separator = separator;
    }

    private String getPasswordOnRecord(String username) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.fileName.getInputStream(), Charset.defaultCharset()));){
            String line = bufferedReader.readLine();
            while (line != null) {
                String[] lineFields = line.split(this.separator);
                String userOnRecord = lineFields[0];
                String passOnRecord = lineFields[1];
                if (username.equals(userOnRecord)) {
                    String string = passOnRecord;
                    return string;
                }
                line = bufferedReader.readLine();
            }
        }
        return null;
    }
}

