/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring31.xml.encryption;

import java.beans.Statement;
import java.security.Provider;
import org.jasypt.digest.ByteDigester;
import org.jasypt.digest.PooledByteDigester;
import org.jasypt.digest.PooledStringDigester;
import org.jasypt.digest.StandardByteDigester;
import org.jasypt.digest.StandardStringDigester;
import org.jasypt.digest.StringDigester;
import org.jasypt.digest.config.DigesterConfig;
import org.jasypt.salt.SaltGenerator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public final class DigesterFactoryBean
implements FactoryBean<Object>,
InitializingBean {
    static final int DIGESTER_TYPE_BYTE = 0;
    static final int DIGESTER_TYPE_STRING = 1;
    private final int digesterType;
    private boolean singleton = true;
    private Object singletonInstance = null;
    private boolean algorithmSet = false;
    private String algorithm = null;
    private boolean configSet = false;
    private DigesterConfig config = null;
    private boolean iterationsSet = false;
    private Integer iterations = null;
    private boolean invertPositionOfPlainSaltInEncryptionResultsSet = false;
    private Boolean invertPositionOfPlainSaltInEncryptionResults = null;
    private boolean invertPositionOfSaltInMessageBeforeDigestingSet = false;
    private Boolean invertPositionOfSaltInMessageBeforeDigesting = null;
    private boolean providerSet = false;
    private Provider provider = null;
    private boolean providerNameSet = false;
    private String providerName = null;
    private boolean poolSizeSet = false;
    private Integer poolSize = null;
    private boolean saltGeneratorSet = false;
    private SaltGenerator saltGenerator = null;
    private boolean saltSizeBytesSet = false;
    private Integer saltSizeBytes = null;
    private boolean useLenientSaltSizeCheckSet = false;
    private Boolean useLenientSaltSizeCheck = null;
    private boolean stringOutputTypeSet = false;
    private String stringOutputType = null;
    private boolean unicodeNormalizationIgnoredSet = false;
    private Boolean unicodeNormalizationIgnored = null;
    private boolean prefixSet = false;
    private String prefix = null;
    private boolean suffixSet = false;
    private String suffix = null;

    public DigesterFactoryBean(int encryptorType) {
        this.digesterType = encryptorType;
    }

    public final void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public final boolean isSingleton() {
        return this.singleton;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        this.algorithmSet = true;
    }

    public void setConfig(DigesterConfig config) {
        this.config = config;
        this.configSet = true;
    }

    public void setIterations(Integer iterations) {
        this.iterations = iterations;
        this.iterationsSet = true;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
        this.poolSizeSet = true;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
        this.providerSet = true;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
        this.providerNameSet = true;
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        this.saltGenerator = saltGenerator;
        this.saltGeneratorSet = true;
    }

    public void setInvertPositionOfPlainSaltInEncryptionResults(Boolean invertPositionOfPlainSaltInEncryptionResults) {
        this.invertPositionOfPlainSaltInEncryptionResults = invertPositionOfPlainSaltInEncryptionResults;
        this.invertPositionOfPlainSaltInEncryptionResultsSet = true;
    }

    public void setInvertPositionOfSaltInMessageBeforeDigesting(Boolean invertPositionOfSaltInMessageBeforeDigesting) {
        this.invertPositionOfSaltInMessageBeforeDigesting = invertPositionOfSaltInMessageBeforeDigesting;
        this.invertPositionOfSaltInMessageBeforeDigestingSet = true;
    }

    public void setSaltSizeBytes(Integer saltSizeBytes) {
        this.saltSizeBytes = saltSizeBytes;
        this.saltSizeBytesSet = true;
    }

    public void setUseLenientSaltSizeCheck(Boolean useLenientSaltSizeCheck) {
        this.useLenientSaltSizeCheck = useLenientSaltSizeCheck;
        this.useLenientSaltSizeCheckSet = true;
    }

    public void setStringOutputType(String stringOutputType) {
        this.stringOutputType = stringOutputType;
        this.stringOutputTypeSet = true;
    }

    public void setUnicodeNormalizationIgnored(Boolean unicodeNormalizationIgnored) {
        this.unicodeNormalizationIgnored = unicodeNormalizationIgnored;
        this.unicodeNormalizationIgnoredSet = true;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.prefixSet = true;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
        this.suffixSet = true;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.singleton) {
            this.singletonInstance = this.computeObject();
        }
    }

    public Object getObject() throws Exception {
        if (this.singleton) {
            return this.singletonInstance;
        }
        return this.computeObject();
    }

    private synchronized Object computeObject() throws Exception {
        Statement st;
        PooledByteDigester digester = null;
        if (this.isPooled()) {
            if (this.digesterType == 0) {
                digester = new PooledByteDigester();
            } else if (this.digesterType == 1) {
                digester = new PooledStringDigester();
            } else {
                throw new IllegalArgumentException("Unknown digester type: " + this.digesterType);
            }
            if (this.poolSizeSet && this.poolSize != null) {
                st = new Statement(digester, "setPoolSize", new Object[]{this.poolSize});
                st.execute();
            }
        } else if (this.digesterType == 0) {
            digester = new StandardByteDigester();
        } else if (this.digesterType == 1) {
            digester = new StandardStringDigester();
        } else {
            throw new IllegalArgumentException("Unknown digester type: " + this.digesterType);
        }
        if (this.algorithmSet) {
            st = new Statement(digester, "setAlgorithm", new Object[]{this.algorithm});
            st.execute();
        }
        if (this.configSet) {
            st = new Statement(digester, "setConfig", new Object[]{this.config});
            st.execute();
        }
        if (this.iterationsSet && this.iterations != null) {
            st = new Statement(digester, "setIterations", new Object[]{this.iterations});
            st.execute();
        }
        if (this.invertPositionOfSaltInMessageBeforeDigestingSet && this.invertPositionOfSaltInMessageBeforeDigesting != null) {
            st = new Statement(digester, "setInvertPositionOfSaltInMessageBeforeDigesting", new Object[]{this.invertPositionOfSaltInMessageBeforeDigesting});
            st.execute();
        }
        if (this.invertPositionOfPlainSaltInEncryptionResultsSet && this.invertPositionOfPlainSaltInEncryptionResults != null) {
            st = new Statement(digester, "setInvertPositionOfPlainSaltInEncryptionResults", new Object[]{this.invertPositionOfPlainSaltInEncryptionResults});
            st.execute();
        }
        if (this.providerSet) {
            st = new Statement(digester, "setProvider", new Object[]{this.provider});
            st.execute();
        }
        if (this.providerNameSet) {
            st = new Statement(digester, "setProviderName", new Object[]{this.providerName});
            st.execute();
        }
        if (this.saltGeneratorSet) {
            st = new Statement(digester, "setSaltGenerator", new Object[]{this.saltGenerator});
            st.execute();
        }
        if (this.saltSizeBytesSet && this.saltSizeBytes != null) {
            st = new Statement(digester, "setSaltSizeBytes", new Object[]{this.saltSizeBytes});
            st.execute();
        }
        if (this.useLenientSaltSizeCheckSet && this.useLenientSaltSizeCheck != null) {
            st = new Statement(digester, "setUseLenientSaltSizeCheck", new Object[]{this.useLenientSaltSizeCheck});
            st.execute();
        }
        if (digester instanceof StringDigester) {
            if (this.stringOutputTypeSet) {
                st = new Statement(digester, "setStringOutputType", new Object[]{this.stringOutputType});
                st.execute();
            }
            if (this.unicodeNormalizationIgnoredSet) {
                st = new Statement(digester, "setUnicodeNormalizationIgnored", new Object[]{this.unicodeNormalizationIgnored});
                st.execute();
            }
            if (this.prefixSet) {
                st = new Statement(digester, "setPrefix", new Object[]{this.prefix});
                st.execute();
            }
            if (this.suffixSet) {
                st = new Statement(digester, "setSuffix", new Object[]{this.suffix});
                st.execute();
            }
        }
        return digester;
    }

    public Class<?> getObjectType() {
        if (this.digesterType == 0) {
            return ByteDigester.class;
        }
        if (this.digesterType == 1) {
            return StringDigester.class;
        }
        throw new IllegalArgumentException("Unknown digester type: " + this.digesterType);
    }

    private boolean isPooled() {
        if (this.poolSizeSet && this.poolSize != null) {
            return true;
        }
        if (this.configSet && this.config != null) {
            return this.config.getPoolSize() != null;
        }
        return false;
    }
}

